<?php
/**
 * BuddyBoss APP Deeplinking Integration.
 *
 * @package BuddyBossApp\Performance
 */

namespace BuddyBossApp\Performance\Integration;

use BuddyBoss\Performance\Cache;
use BuddyBoss\Performance\Helper;
use BuddyBoss\Performance\Integration\Integration_Abstract;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Deeplinking Integration Class.
 *
 * @package BuddyBossApp\Performance
 */
class BBAPP_DeepLinking extends Integration_Abstract {

	/**
	 * Add(Start) Integration
	 *
	 * @return mixed|void
	 */
	public function set_up() {
		$this->register( 'bbapp-deeplinking' );

		$deeplinking_cache_args = array();

		//BuddyBoss
		$is_component_active           = Helper::instance()->get_app_settings( 'cache_component', 'buddyboss-app' );

		//BuddyBoss App
		$bbapp_blog_post_settings = Helper::instance()->get_app_settings( 'cache_blog_post', 'buddyboss-app' );
		$bbapp_app_page_settings  = Helper::instance()->get_app_settings( 'cache_app_page', 'buddyboss-app' );

		// LearnDash.
		$ld_settings = Helper::instance()->get_app_settings( 'cache_ld', 'buddyboss-app' );

		// Blog Post
		if ( ! empty( $is_component_active ) && ! empty( $bbapp_blog_post_settings ) ) {
			$deeplinking_cache_args['blog_post'] = array(
				'action'    => array( 'open_post' ),
				'namespace' => array( 'core' )
			);
		}

		// App Page
		if ( ! empty( $is_component_active ) && ! empty( $bbapp_app_page_settings ) ) {
			$deeplinking_cache_args['app_page'] = array(
				'action'    => array( 'open_app_page' ),
				'namespace' => array( 'core' )
			);
		}

		// LearnDash
		if ( ! empty( $is_component_active ) && ! empty( $ld_settings ) ) {
			$deeplinking_cache_args['sfwd-courses'] = array(
				'action'    => array( 'open_sfwd-courses' ),
				'namespace' => array( 'core' )
			);
			$deeplinking_cache_args['sfwd-lessons'] = array(
				'action'    => array( 'open_sfwd-lessons' ),
				'namespace' => array( 'core' )
			);
			$deeplinking_cache_args['sfwd-topic'] = array(
				'action'    => array( 'open_sfwd-topic' ),
				'namespace' => array( 'core' )
			);
			$deeplinking_cache_args['sfwd-quiz'] = array(
				'action'    => array( 'open_sfwd-quiz' ),
				'namespace' => array( 'core' )
			);
		}

		/**
		 * Allow to Cache Custom deeplinking items.
		 */
		$deeplinking_cache_args = apply_filters( 'bbapp_performance_deep_linking_supported_items', $deeplinking_cache_args );

		if ( ! empty( $deeplinking_cache_args ) ) {
			// Check if the cache_expiry static method exists and call it, or get the value from an instance.
			$cache_expiry_time = method_exists('BuddyBoss\Performance\Cache', 'cache_expiry') ? Cache::cache_expiry() : Cache::instance()->month_in_seconds;

			$this->cache_endpoint(
				'buddyboss-app/core/v1/bulk-url-details',
				$cache_expiry_time,
				array(
					'request_method' => 'POST',
					'unique_id'      => 'url',
					'include_param'  => 'urls',
					'deep_link_args' => $deeplinking_cache_args
				),
				true,
				true
			);

			$this->cache_endpoint(
				'buddyboss-app/core/v1/url-details',
				$cache_expiry_time,
				array(
					'request_method' => 'POST',
					'unique_id'      => 'url',
					'include_param'  => 'urls',
					'deep_link_args' => $deeplinking_cache_args
				),
				false,
				true
			);

			add_filter( 'bbapp_performance_deep_cache_filter_item', array( $this, 'filter_item' ), 10, 4 );
			add_filter( 'bbapp_performance_deep_filter_cached_data', array( $this, 'filter_cached_data' ), 10, 3 );
			add_filter( 'bbapp_performance_deep_filter_param_value', array( $this, 'filter_param_value' ), 10, 3 );
		}
	}

	/**
	 * Check whether cache is enabled for URL with single endpont
	 *
	 * @param array|string $enabled          Cache need to be store or not.
	 * @param array        $result_data      api response result.
	 * @param array        $args             argument of current cache request.
	 * @param string|array $integration_name integration name (like, 'bbapp-deeplinking','bp-activity').
	 *
	 * @return mixed|string
	 */
	public function filter_item( $enabled, $result_data, $args, $integration_name ) {

		if ( 'bbapp-deeplinking' === $integration_name ) {
			foreach ( $args['deep_link_args'] as $deep_link_arg ) {

				if ( ! empty( $result_data[ $args['unique_id'] ] ) && in_array( $result_data['action'], $deep_link_arg['action'] ) && in_array( $result_data['namespace'], $deep_link_arg['namespace'] ) ) {
					return true;
				}
			}

			return false;
		}

		return $enabled;
	}

	/**
	 * Some new Url we added and we didn't cache that url in cache data so we need to overwrite this
	 *
	 * @param array|boolean $cached_data      cache value data.
	 * @param array|string  $args             argument of current cache request.
	 * @param string|array  $integration_name integration name (like, 'bbapp-deeplinking','bp-activity').
	 *
	 * @return array|false
	 */
	public function filter_cached_data( $cached_data, $args, $integration_name ) {
		if ( 'bbapp-deeplinking' === $integration_name ) {
			if ( ! empty( $cached_data ) ) {
				if ( ! empty( $_POST['urls'] ) ) {
					return array_map(function ($url){
						return trailingslashit( $url );
					},$_POST['urls']);
				}
			}

			return array();
		}

		return $cached_data;
	}

	/**
	 * Some new Url we added and we didn't cache that url in cache data so we need to overwrite this
	 *
	 * @param string       $param_value      cache param value.
	 * @param array|string $args             argument of current cache request.
	 * @param string|array $integration_name integration name (like, 'bbapp-deeplinking','bp-activity').
	 *
	 * @return array|false
	 */
	public function filter_param_value( $param_value, $args, $integration_name ) {
		if ( 'bbapp-deeplinking' === $integration_name ) {
			if ( ! empty( $_POST['url'] ) ) {
				return trailingslashit( $_POST['url'] );
			}
		}

		return $param_value;
	}
}
