<?php
/**
 * BuddyBoss APP Pages integration.
 *
 * @package BuddyBossApp\Performance
 */

namespace BuddyBossApp\Performance\Integration;

use BuddyBoss\Performance\Cache;
use BuddyBoss\Performance\Helper;
use BuddyBoss\Performance\Integration\Integration_Abstract;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * App Pages Integration Class.
 *
 * @package BuddyBossApp\Performance
 */
class BB_App_Pages extends Integration_Abstract {

	/**
	 * Add(Start) Integration
	 *
	 * @return mixed|void
	 */
	public function set_up() {
		$this->register( 'app_page' );

		// @todo : Re-verify events for single  app_page
		$purge_single_events = array(
			'save_post_app_page' => 1, // Called when app_page is saved in backend.
			'edit_post_app_page' => 1, // Called when app_page is updated in backend.
		);

		$this->purge_single_events( $purge_single_events );

		// NOTE : Getting admin settings to toggle api cache.
		$is_component_active     = Helper::instance()->get_app_settings( 'cache_component', 'buddyboss-app' );
		$settings                = Helper::instance()->get_app_settings( 'cache_app_page', 'buddyboss-app' );
		$cache_support_app_pages = isset( $is_component_active ) && isset( $settings ) ? ( $is_component_active && $settings ) : false;

		if ( $cache_support_app_pages ) {

			// Check if the cache_expiry static method exists and call it, or get the value from an instance.
			$cache_expiry_time = method_exists('BuddyBoss\Performance\Cache', 'cache_expiry') ? Cache::cache_expiry() : Cache::instance()->month_in_seconds;

			// Endpoint-1: wp-json/wp/v2/app_pages.
			$this->cache_endpoint(
				'wp/v2/app_pages/<id>',
				$cache_expiry_time,
				array(),
				false
			);
		}
	}

	/**
	 * When app page created
	 *
	 * @param int $apppage_id Page ID.
	 */
	public function event_save_post_app_page( $apppage_id ) {
		Cache::instance()->purge_by_group( 'app_page_' . $apppage_id );
		Cache::instance()->purge_by_group( 'bbapp-deeplinking_' . get_permalink( $apppage_id ) );
	}

	/**
	 * When app page updated
	 *
	 * @param int $apppage_id Page ID.
	 */
	public function event_edit_post_app_page( $apppage_id ) {
		Cache::instance()->purge_by_group( 'app_page_' . $apppage_id );
		Cache::instance()->purge_by_group( 'bbapp-deeplinking_' . get_permalink( $apppage_id ) );
	}
}
