<?php
/**
 * BuddyBoss APP Core integration.
 *
 * @package BuddyBossApp\Performance
 */

namespace BuddyBossApp\Performance\Integration;

use BuddyBoss\Performance\Cache;
use BuddyBoss\Performance\Helper;
use BuddyBoss\Performance\Integration\Integration_Abstract;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * App Pages Integration Class.
 *
 * @package BuddyBossApp\Performance
 */
class BB_App_Core extends Integration_Abstract {

	/**
	 * Add(Start) Integration
	 *
	 * @return mixed|void
	 */
	public function set_up() {
		$this->register( 'app_core' );

		// @todo : Re-verify events for single  app_core
		$purge_single_events = array(
			'add_option'    => 2, // Called when app_core is add in backend.
			'update_option' => 3, // Called when app_core is update in backend.
			'delete_option' => 1, // Called when app_core is delete in backend.
		);

		$this->purge_single_events( $purge_single_events );

		// NOTE : Getting admin settings to toggle api cache.
		$is_component_active     = Helper::instance()->get_app_settings( 'cache_component', 'buddyboss-app' );
		$settings                = Helper::instance()->get_app_settings( 'cache_app_core', 'buddyboss-app' );
		$cache_support_app_cores = isset( $is_component_active ) && isset( $settings ) ? ( $is_component_active && $settings ) : false;

		if ( $cache_support_app_cores ) {

			// Check if the cache_expiry static method exists and call it, or get the value from an instance.
			$cache_expiry_time = method_exists('BuddyBoss\Performance\Cache', 'cache_expiry') ? Cache::cache_expiry() : Cache::instance()->month_in_seconds;

			// Endpoint-1: wp-json/buddyboss-app/core/v1/menu.
			$this->cache_endpoint(
				'buddyboss-app/core/v1/menu',
				$cache_expiry_time,
				array(),
				false
			);
			// Endpoint-1: wp-json/buddyboss-app/core/v1/menu/<app_id>.
			$this->cache_endpoint(
				'buddyboss-app/core/v1/menu/<app_id>',
				$cache_expiry_time,
				array(),
				false
			);

			// Endpoint-1: wp-json/buddyboss-app/core/v1/settings.
			$this->cache_endpoint(
				'buddyboss-app/core/v1/settings',
				$cache_expiry_time,
				array(),
				false
			);
			// Endpoint-1: wp-json/buddyboss-app/core/v1/settings.
			$this->cache_endpoint(
				'buddyboss-app/core/v1/settings/<app_id>',
				$cache_expiry_time,
				array(),
				false
			);
		}
	}

	/**
	 * When Add option
	 *
	 * @param string|array $option option.
	 * @param string|array $value  value.
	 */
	public function event_add_option( $option, $value ) {
		Cache::instance()->purge_by_group( 'app_core' );
	}

	/**
	 * When Update Option
	 *
	 * @param string|array $old_value Old value.
	 * @param string|array $value     value.
	 * @param string|array $option    option.
	 */
	public function event_update_option( $old_value, $value, $option ) {
		Cache::instance()->purge_by_group( 'app_core' );
	}

	/**
	 * When Delete Option.
	 *
	 * @param string|array $option option.
	 */
	public function event_delete_option( $option ) {
		Cache::instance()->purge_by_group( 'app_core' );
	}
}
