<?php
/**
 * BuddyBoss APP Categories integration.
 *
 * @package BuddyBossApp\Performance
 */

namespace BuddyBossApp\Performance\Integration;

use BuddyBoss\Performance\Cache;
use BuddyBoss\Performance\Helper;
use BuddyBoss\Performance\Integration\Integration_Abstract;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * App Categories Integration Class.
 *
 * @package BuddyBossApp\Performance
 */
class BB_App_Categories extends Integration_Abstract {

	/**
	 * Add(Start) Integration
	 *
	 * @return mixed|void
	 */
	public function set_up() {
		$this->register( 'categories' );

		$purge_events = array(
			'saved_category', // Called when categories is saved in backend.
			'set_object_terms', // Called when blog_post is updated in backend.
		);

		$this->purge_event( 'categories', $purge_events );

		// @todo : Re-verify events for single categories
		$purge_single_events = array(
			'saved_category'   => 3, // Called when categories is saved in backend.
			'set_object_terms' => 6, // Called when blog_post is updated in backend.
		);

		$this->purge_single_events( $purge_single_events );

		// NOTE : Getting admin settings to toggle api cache.
		$is_component_active      = Helper::instance()->get_app_settings( 'cache_component', 'buddyboss-app' );
		$settings                 = Helper::instance()->get_app_settings( 'cache_categories', 'buddyboss-app' );
		$cache_support_categories = isset( $is_component_active ) && isset( $settings ) ? ( $is_component_active && $settings ) : false;

		if ( $cache_support_categories ) {

			// Check if the cache_expiry static method exists and call it, or get the value from an instance.
			$cache_expiry_time = method_exists('BuddyBoss\Performance\Cache', 'cache_expiry') ? Cache::cache_expiry() : Cache::instance()->month_in_seconds;

			// Endpoint-1: wp/v2/categories.
			$this->cache_endpoint(
				'wp/v2/categories',
				$cache_expiry_time,
				array(
					'unique_id'         => 'id',
				),
				true
			);
		}
	}

	/**
	 * When Category Created.
	 *
	 * @param int  $term_id Term ID.
	 * @param int  $tt_id   Term taxonomy ID.
	 * @param bool $bool    Whether this is an existing term being updated.
	 */
	public function event_saved_category( $term_id, $tt_id, $bool ) {
		Cache::instance()->purge_by_group( 'categories_' . $term_id );
	}

	/**
	 * Terms object update based on post id.
	 *
	 * @param int    $object_id  Object ID.
	 * @param array  $terms      An array of object terms.
	 * @param array  $tt_ids     An array of term taxonomy IDs.
	 * @param string $taxonomy   Taxonomy slug.
	 * @param bool   $append     Whether to append new terms to the old terms.
	 * @param array  $old_tt_ids Old array of term taxonomy IDs.
	 */
	public function event_set_object_terms( $object_id, $terms, $tt_ids, $taxonomy, $append, $old_tt_ids ) {
		if ( empty( $tt_ids ) ) {
			return;
		}

		Cache::instance()->purge_by_group_names( $tt_ids, array( 'categories_' ) );
	}
}
