<?php
/**
 * BuddyBoss App Performance load
 *
 * @package BuddyBoss\App\Performance
 */

if ( ! function_exists( 'bbapp_performance_load' ) ) {
	/**
	 * Load the mu level code.
	 */
	function bbapp_performance_load() {
		$components = get_option( 'bbapp_active_components', array() );

		if ( isset( $components['performance'] ) && ! $components['performance'] ) {
			return;
		}

		if ( ! class_exists( 'BuddyBoss\Performance\Performance' ) ) {
			require_once __DIR__ . '/class-performance.php';
			\BuddyBoss\Performance\Performance::instance();
		}

		$include = __DIR__ . '/class-bbapp-performance.php';
		if ( file_exists( $include ) ) {
			require_once $include;
			\BuddyBossApp\Performance\BuddyBossApp_Performance::instance();
		}
	}

	add_action( 'muplugins_loaded', 'bbapp_performance_load', 30 );
}
