<?php
/**
 * Holds functionality related push notification integration.
 *
 * @package BuddyBossApp\Integrations
 */

namespace BuddyBossApp\Integrations;

use BuddyBossApp\Notification\IntegrationAbstract;
use BuddyBossApp\Notification\Push;

/**
 * Push integration class.
 */
class CoreIntegration extends IntegrationAbstract {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	protected static $instance;

	/**
	 * Load function.
	 *
	 * @return mixed|void
	 */
	public function load() {
		$this->register_component( 'bbapp', true );
		$this->register_push_group( 'announcements', __( 'Announcements', 'buddyboss-app' ) );
		$this->register_push_type(
			'manual_push_notification',
			__( 'Manual notifications sent by the admin', 'buddyboss-app' ),
			__( 'Manual notifications sent by the admin', 'buddyboss-app' ),
			array(
				'push_group' => 'announcements',
				'is_topic'   => true,
			)
		);
	}

	/**
	 * Format the notifications for API and Web.
	 *
	 * @param string $component_name    Component name.
	 * @param string $component_action  Component action.
	 * @param int    $item_id           Push notification id.
	 * @param int    $secondary_item_id Secondary id.
	 * @param int    $notification_id   Push notification id.
	 * @param int    $total_items       Number of total items.
	 * @param string $screen            Screen id.
	 *
	 * @return false|array {
	 *  "link" => "" // Must be URL eg. http://example.com/example/example
	 *  "text" => "" // Link Text eg. Someone replied to your topic.
	 * }
	 */
	public function format_notification( $component_name, $component_action, $item_id, $secondary_item_id, $notification_id, $total_items, $screen ) {

		if ( 'bbapp' === $component_name && 'manual_push' === $component_action ) {

			$notification = Push::instance()->get_notification( $item_id );

			$text = __( 'Content not available.', 'buddyboss-app' );
			$link = '';

			if ( ! empty( $notification ) ) {
				$text = $notification->secondary_text;
				$link = isset( $notification->data['link'] ) ? $notification->data['link'] : '';
			}

			return array(
				'text' => $text,
				'link' => $link,
			);
		}

		return false;
	}
}
