<?php
/**
 * Directory Block
 *
 * @package BuddyBossApp\Api\DirectoryBlock
 */

namespace BuddyBossApp\NativeAppPage;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Directory Block
 */
class DirectoryBlock {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	public static $instance;

	/**
	 * Directory block constructor.
	 */
	public function __construct() {
	}

	/**
	 * Get the instance of the class.
	 *
	 * @return DirectoryBlock
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Filters/hooks here.
	 *
	 * @since 2.3.40
	 */
	public function load() {
		$this->load_classes();
		$this->load_hook();
	}

	/**
	 * Load classes.
	 *
	 * @since 2.3.40
	 */
	public function load_classes() {
		\BuddyBossApp\Api\DirectoryBlock\Directory_Block::instance();
	}

	/**
	 * Load hook.
	 *
	 * @since 2.3.40
	 */
	public function load_hook() {
		add_action( 'enqueue_block_editor_assets', array( $this, 'gutenberg_variables' ), 999999 );
		add_filter( 'bbapp_block_filter_options', array( $this, 'bbapp_block_filter_options' ), 10, 2 );
	}

	/**
	 * Gutenberg variables.
	 *
	 * @since 2.3.40
	 */
	public function gutenberg_variables() {
		wp_localize_script(
			bbapp()->plugin_prefix . 'gutenberg',
			'bbappDirectory',
			array(
				'postTypes' => array_map(
					function ( $post_type ) {
						return array(
							'label' => $post_type->label,
							'slug'  => $post_type->name,
						);
					},
					\BuddyBossApp\Api\DirectoryBlock\Directory_Block::instance()->get_public_rest_post_types()
				),
			)
		);
	}

	/**
	 * Remove post_format from the filter options.
	 *
	 * @param array  $show_filter_options The filter options.
	 * @param string $post_type The post type.
	 * @return array The filter options.
	 *
	 * @since 2.3.40
	 *
	 * @return array The filter options.
	 */
	public function bbapp_block_filter_options( $show_filter_options, $post_type ) {
		if ( 'post' === $post_type ) {
			foreach ( $show_filter_options as $key => $value ) {
				if ( 'post_format' === $value['name'] ) {
					unset( $show_filter_options[ $key ] );
				}
			}

			// Reindex array to prevent object conversion in JSON.
			$show_filter_options = array_values( $show_filter_options );
		}

		return $show_filter_options;
	}
}
