<?php
/**
 * Holds deprecated gutenberg blocks code.
 *
 * @package BuddyBossApp\NativeAppPage
 */

namespace BuddyBossApp\NativeAppPage;

use WP_Post;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Contain App Page Gutenberg related things.
 */
class Deprecated_Content {

	/**
	 * Deprecated prefix.
	 *
	 * @var string $prefix
	 */
	public $prefix = 'deprecate_';

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	public static $instance;

	/**
	 * Deprecated_Content constructor.
	 */
	public function __construct() {
	}

	/**
	 * Get the instance of the class.
	 *
	 * @return Deprecated_Content
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Load hooks.
	 */
	public function load() {
		$this->hooks();
	}

	/**
	 * Define all Hooks.
	 */
	public function hooks() {
		add_action( 'admin_init', array( $this, 'ap_init' ) );
	}

	/**
	 * BuddyBoss App init.
	 */
	public function ap_init() {
		add_action( 'the_post', array( $this, 'ap_the_post' ), 10 );
		add_filter( 'get_post_metadata', array( $this, 'ap_the_post_meta' ), 9999, 4 );
		add_filter( 'ap_gutenberg_app_page_editor_content', array( $this, 'page_editor_content' ), 99, 2 );
	}

	/**
	 * App page content update.
	 *
	 * @param WP_Post $post Wp post.
	 */
	public function ap_the_post( $post ) {
		if ( 'app_page' === $post->post_type ) {
			$content            = $post->post_content;
			$post->post_content = $this->fix_gutenberg_blocks( $content );
		}
	}

	/**
	 * App page content update.
	 *
	 * @param string     $metadata  Meta data content.
	 * @param int        $object_id Object id.
	 * @param int|string $meta_key  Meta key.
	 * @param bool       $single    If needs to return single value.
	 *
	 * @return mixed|string
	 */
	public function ap_the_post_meta( $metadata, $object_id, $meta_key, $single ) {
		if ( '_app_page_editor_content' === $meta_key ) {
			return ! empty( $metadata ) ? $this->fix_gutenberg_blocks( $metadata ) : $metadata;
		}

		return $metadata;
	}

	/**
	 * Get page editor content.
	 *
	 * @param string $app_page_editor  App page editor content.
	 * @param string $native_editor_id Native editor id.
	 *
	 * @return string
	 */
	public function page_editor_content( $app_page_editor, $native_editor_id ) {
		return $this->fix_gutenberg_blocks( $app_page_editor );
	}

	/**
	 * Fix gutenberg blocks.
	 *
	 * @param string $content Content.
	 *
	 * @return string
	 */
	public function fix_gutenberg_blocks( $content ) {
		$parse_blocks             = parse_blocks( $content );
		$gutenberg_blocks_content = $this->parse_gutenberg_blocks( $parse_blocks );
		$gutenberg_blocks_content = implode( '', $gutenberg_blocks_content );

		return ! empty( $gutenberg_blocks_content ) ? $gutenberg_blocks_content : $content;
	}

	/**
	 * Search block.
	 *
	 * @param array $exclude_block Array of excluded blocks.
	 * @param array $array         Array of blocks.
	 *
	 * @return bool
	 */
	public function search_for_id( $exclude_block, $array ) {
		foreach ( $array as $key => $val ) {
			if ( in_array( $val['blockName'], $exclude_block, true ) ) {
				continue;
			}

			if ( ! empty( $val['blockName'] ) && strpos( $val['blockName'], 'bbapp' ) !== false ) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Parse gutenberg block.
	 *
	 * @param array $blocks Blocks.
	 *
	 * @return array
	 */
	public function parse_gutenberg_blocks( $blocks ) {
		$exclude_block_convert = apply_filters(
			'bbapp_allowed_custom_block_for_app_content',
			array(
				'bbapp/my-progress',
				'bbapp/courses',
				'bbapp/mp-courses',
				'bbapp/tutor-courses',
				'bbapp/posts',
				'bbapp/directory',
				'bbapp/topics',
				'bbapp/forums',
				'bbapp/groups',
				'bbapp/members',
				'bbapp/h5p',
				'bbapp/notifications',
				'bbapp/qlinks',
				'bbapp/activity',
			)
		);
		$new_app_page_data     = array();
		$block_slug            = 'bbapp';

		if ( false === $this->search_for_id( $exclude_block_convert, $blocks ) ) {
			return array();
		}

		foreach ( $blocks as $key => $block_data ) {
			if ( ! empty( $block_data['blockName'] ) ) {
				switch ( $block_data['blockName'] ) {
					case $block_slug . '/my-progress':
					case $block_slug . '/courses':
					case $block_slug . '/posts':
					case $block_slug . '/topics':
					case $block_slug . '/forums':
					case $block_slug . '/groups':
					case $block_slug . '/users':
					case $block_slug . '/members':
					case $block_slug . '/notifications':
					case $block_slug . '/qlinks':
					case $block_slug . '/activity':
						$block_content_result = $this->parse_bbapp_block( $block_data );
						break;
					case $block_slug . '/paragraph':
					case $block_slug . '/heading':
					case $block_slug . '/quote':
					case $block_slug . '/image':
					case $block_slug . '/list':
					case $block_slug . '/video':
					case $block_slug . '/table':
					case $block_slug . '/html':
					case $block_slug . '/cover':
					case $block_slug . '/button':
					case $block_slug . '-embed/youtube':
					case $block_slug . '-embed/vimeo':
						$block_content_result = $this->parse_common_convert_block( $block_data );
						break;
					case $block_slug . '/columns':
					case $block_slug . '/media-text':
						$block_content_result = $this->parse_convert_block( $block_data );
						break;
					case $block_slug . '/audio':
						$block_content_result = $this->parse_audio_block( $block_data );
						break;
					case $block_slug . '/gallery':
						$block_content_result = $this->parse_gallery_block( $block_data );
						break;
					default:
						$block_content_result = $this->parse_common_convert_block( $block_data );
				}

				array_push( $new_app_page_data, $block_content_result );
			}
		}

		return $new_app_page_data;
	}

	/**
	 * Common convertible blocks.
	 *
	 * @param array  $block_data        Block data.
	 * @param string $allowed_html      Allowed HTML.
	 * @param array  $allowed_protocols Allowed protocols.
	 *
	 * @return string
	 */
	public function parse_common_convert_block( $block_data, $allowed_html = 'post', $allowed_protocols = array() ) {
		$block_data = $this->ap_block_name_replace( $block_data );
		// Replace the content.
		$block_data = $this->ap_inner_content_class_replace( $block_data );
		$block_data = filter_block_kses( $block_data, $allowed_html, $allowed_protocols );

		return serialize_block( $block_data );
	}

	/**
	 * BuddyBoss App block with we need to re render only.
	 *
	 * @param array  $block_data        Block data.
	 * @param string $allowed_html      Allowed HTML.
	 * @param array  $allowed_protocols Allowed protocols.
	 *
	 * @return string
	 */
	public function parse_bbapp_block( $block_data, $allowed_html = 'post', $allowed_protocols = array() ) {
		$block_data = filter_block_kses( $block_data, $allowed_html, $allowed_protocols );

		return serialize_block( $block_data );
	}

	/**
	 * Columns and media text box.
	 *
	 * @param array  $block_data        Block data.
	 * @param string $allowed_html      Allowed HTML.
	 * @param array  $allowed_protocols Allowed protocols.
	 *
	 * @return string|string[]
	 */
	public function parse_convert_block( $block_data, $allowed_html = 'post', $allowed_protocols = array() ) {
		$block_data = $this->ap_block_name_replace( $block_data );

		if ( isset( $block_data['innerBlocks'] ) && ! empty( $block_data['innerBlocks'] ) && array_filter( $block_data['innerBlocks'] ) ) {
			foreach ( $block_data['innerBlocks'] as $key => $inner_blocks ) {
				$block_data['innerBlocks'][ $key ]['blockName'] = str_replace( 'bbapp/', '', $block_data['innerBlocks'][ $key ]['blockName'] );
				$block_data['innerBlocks'][ $key ]['blockName'] = str_replace( 'bbapp-', 'core-', $block_data['innerBlocks'][ $key ]['blockName'] );
				$block_data['innerBlocks'][ $key ]              = $this->ap_inner_content_class_replace( $block_data['innerBlocks'][ $key ] );
				$block_data['innerBlocks'][ $key ]              = filter_block_kses( $block_data['innerBlocks'][ $key ], $allowed_html, $allowed_protocols );
			}
		}

		return str_replace( 'wp-block-bbapp-', 'wp-block-', serialize_block( $block_data ) );
	}

	/**
	 * Audio block.
	 *
	 * @param array  $block_data        Block data.
	 * @param string $allowed_html      Allowed HTML.
	 * @param array  $allowed_protocols Allowed protocols.
	 *
	 * @return string|string[]|null
	 */
	public function parse_audio_block( $block_data, $allowed_html = 'post', $allowed_protocols = array() ) {
		$block_data = $this->ap_block_name_replace( $block_data );
		// Replace the content.
		$block_data      = $this->ap_inner_content_class_replace( $block_data );
		$block_data      = filter_block_kses( $block_data, $allowed_html, $allowed_protocols );
		$serialize_block = serialize_block( $block_data );

		if ( ! preg_match( '/<audio controls/', $serialize_block ) ) {
			$serialize_block = preg_replace( '/<audio/', '<audio controls', $serialize_block );
		}

		return $serialize_block;
	}

	/**
	 * Gallery block.
	 *
	 * @param array  $block_data        Block data.
	 * @param string $allowed_html      Allowed html.
	 * @param array  $allowed_protocols Allowed protocols.
	 *
	 * @return string|string[]
	 */
	public function parse_gallery_block( $block_data, $allowed_html = 'post', $allowed_protocols = array() ) {
		$block_data = $this->ap_block_name_replace( $block_data );
		// Replace the content.
		$block_data   = $this->ap_inner_content_class_replace( $block_data );
		$gallery_html = '';
		$nodes        = $this->extract_tags( $block_data['innerContent'][0], 'ul' );

		foreach ( $nodes as $ul_element ) {
			$attributes = $ul_element['attributes'];
			$style      = '';

			foreach ( $attributes as $key => $attribute ) {
				if ( 'class' === $key ) {
					// BuddyBoss App Gallery block issue that why added this thing.
					$attribute = preg_replace( "/'is-cropped'/", 'is-cropped', $attribute );
					$attribute = preg_replace( '/}/', '', $attribute );
				}

				$style .= $key . '="' . $attribute . '"';
			}

			$gallery_html .= '<figure ' . $style . '>';
			$gallery_html .= '<ul class="blocks-gallery-grid">';
			$gallery_html .= $ul_element['contents'];
			$gallery_html .= '</ul>';
			$gallery_html .= '</figure>';
		}

		$block_data['innerContent'][0] = $gallery_html;
		$block_data                    = filter_block_kses( $block_data, $allowed_html, $allowed_protocols );
		$block_content                 = str_replace( 'wp-block-bbapp-', 'wp-block-', serialize_block( $block_data ) );

		return $block_content;
	}

	/**
	 * Replace content class name.
	 *
	 * @param array $block Block data.
	 *
	 * @return mixed
	 */
	public function ap_inner_content_class_replace( $block ) {
		if ( is_array( $block['innerContent'] ) ) {
			foreach ( $block['innerContent'] as $key => $inner_content ) {
				$block['innerContent'][ $key ] = str_replace( 'wp-block-bbapp-', 'wp-block-', $block['innerContent'][ $key ] );
			}
		} else {
			$block['innerContent'] = str_replace( 'wp-block-bbapp-', 'wp-block-', $block['innerContent'] );
		}

		return $block;
	}

	/**
	 * Replace block name.
	 *
	 * @param array $block Block data.
	 *
	 * @return mixed
	 */
	public function ap_block_name_replace( $block ) {
		$block['blockName'] = str_replace( 'bbapp/', '', $block['blockName'] );
		$block['blockName'] = str_replace( 'bbapp-', 'core-', $block['blockName'] );

		return $block;
	}

	/**
	 * Extract html tag.
	 *
	 * @param string $html                  Html.
	 * @param array  $tag                   Tag.
	 * @param null   $selfclosing           If it's self focusing.
	 * @param false  $return_the_entire_tag If needs to return entire tag.
	 * @param string $charset               Character set.
	 *
	 * @return array
	 */
	public function extract_tags( $html, $tag, $selfclosing = null, $return_the_entire_tag = false, $charset = 'ISO-8859-1' ) {
		if ( is_array( $tag ) ) {
			$tag = implode( '|', $tag );
		}

		// If the user didn't specify if $tag is a self-closing tag we try to auto-detect it
		// by checking against a list of known self-closing tags.
		$selfclosing_tags = array(
			'area',
			'base',
			'basefont',
			'br',
			'hr',
			'input',
			'img',
			'link',
			'meta',
			'col',
			'param',
		);

		if ( is_null( $selfclosing ) ) {
			$selfclosing = in_array( $tag, $selfclosing_tags, true );
		}

		// The regexp is different for normal and self-closing tags because I can't figure out
		// how to make a sufficiently robust unified one.
		if ( $selfclosing ) {
			$tag_pattern =
				'@<(?P<tag>' . $tag . ')           # <tag
            (?P<attributes>\s[^>]+)?       # attributes, if any
            \s*/?>                   # /> or just >, being lenient here 
            @xsi';
		} else {
			$tag_pattern =
				'@<(?P<tag>' . $tag . ')           # <tag
            (?P<attributes>\s[^>]+)?       # attributes, if any
            \s*>                 # >
            (?P<contents>.*?)         # tag contents
            </(?P=tag)>               # the closing </tag>
            @xsi';
		}

		$attribute_pattern =
			'@
        (?P<name>\w+)                         # attribute name
        \s*=\s*
        (
            (?P<quote>[\"\'])(?P<value_quoted>.*?)(?P=quote)    # a quoted value
            |                           # or
            (?P<value_unquoted>[^\s"\']+?)(?:\s+|$)           # an unquoted value (terminated by whitespace or EOF) 
        )
        @xsi';

		// Find all tags.
		if ( ! preg_match_all( $tag_pattern, $html, $matches, PREG_SET_ORDER | PREG_OFFSET_CAPTURE ) ) {
			// Return an empty array if we didn't find anything.
			return array();
		}

		$tags = array();

		foreach ( $matches as $match ) {
			// Parse tag attributes, if any.
			$attributes = array();

			if ( ! empty( $match['attributes'][0] ) ) {
				if ( preg_match_all( $attribute_pattern, $match['attributes'][0], $attribute_data, PREG_SET_ORDER ) ) {
					// Turn the attribute data into a name->value array.
					foreach ( $attribute_data as $attr ) {
						if ( ! empty( $attr['value_quoted'] ) ) {
							$value = $attr['value_quoted'];
						} elseif ( ! empty( $attr['value_unquoted'] ) ) {
							$value = $attr['value_unquoted'];
						} else {
							$value = '';
						}
						// Passing the value through html_entity_decode is handy when you want
						// to extract link URLs or something like that. You might want to remove
						// or modify this call if it doesn't fit your situation.
						$value                       = html_entity_decode( $value, ENT_QUOTES, $charset );
						$attributes[ $attr['name'] ] = $value;
					}
				}
			}

			$tag = array(
				'tag_name'   => $match['tag'][0],
				'offset'     => $match[0][1],
				'contents'   => ! empty( $match['contents'] ) ? $match['contents'][0] : '',
				// empty for self-closing tags.
				'attributes' => $attributes,
			);

			if ( $return_the_entire_tag ) {
				$tag['full_tag'] = $match[0][0];
			}

			$tags[] = $tag;
		}

		return $tags;
	}

	/**
	 * Get correct content of quick link block.
	 *
	 * @param string $content Content.
	 *
	 * @return mixed|string
	 * @since 1.4.5
	 */
	public function bbapp_get_block_content( $content ) {
		$parse_blocks = parse_blocks( $content );

		if ( ! in_array( 'bbapp/qlinks', array_column( $parse_blocks, 'blockName' ), true ) ) {
			return '';
		}

		$quick_link_obj = array();
		$new_content    = '';

		foreach ( $parse_blocks as $key => $parse_block ) {
			if ( 'bbapp/qlinks' === $parse_block['blockName'] ) {
				if ( ! empty( $parse_block['attrs']['quickLinksType'] ) ) {
					foreach ( $parse_block['attrs']['quickLinksType'] as $index => $quick_links_type ) {
						$title    = '';
						$url      = '';
						$icon_url = '';
						$icon_val = $parse_block['attrs']['quickLinksIconValue'][ $index ];
						$id       = '';

						if ( 'link' === $quick_links_type ) {
							$title    = $parse_block['attrs']['quickLinksSelected'][ $index ]['title'];
							$icon_url = $parse_block['attrs']['quickLinksSelected'][ $index ]['icon'];
							$id       = $parse_block['attrs']['quickLinksProfileLinksID'][ $index ];
						} elseif ( 'app_page' === $quick_links_type ) {
							$title = get_the_title( $parse_block['attrs']['appPageID'][ $index ] );
							$url   = get_permalink( $parse_block['attrs']['appPageID'][ $index ] );
							$id    = $parse_block['attrs']['appPageID'][ $index ];
						} elseif ( 'custom_link' === $quick_links_type ) {
							$title    = $parse_block['attrs']['quickLinksTitle'][ $index ];
							$url      = $parse_block['attrs']['quickLinksURL'][ $index ];
							$icon_url = ! empty( $parse_block['attrs']['quickLinksIconURL'][ $index ] ) ? $parse_block['attrs']['quickLinksIconURL'][ $index ] : bbapp_tabbar_get_selected_icon( $parse_block['attrs']['quickLinksIconValue'][ $index ], 'outlined' );
						}

						$icon_url                            = ! empty( $icon_url ) ? $icon_url : $parse_block['attrs']['quickLinksIconURL'][ $index ];
						$quick_link_obj[ $index ]['type']    = $quick_links_type;
						$quick_link_obj[ $index ]['title']   = $title;
						$quick_link_obj[ $index ]['link']    = $url;
						$quick_link_obj[ $index ]['iconUrl'] = $icon_url;
						$quick_link_obj[ $index ]['iconVal'] = $icon_val;
						$quick_link_obj[ $index ]['id']      = $id;
					}

					$parse_blocks[ $key ]['attrs']['quickLinkObj'] = $quick_link_obj;

					unset( $parse_blocks[ $key ]['attrs']['quickLinksType'] );
					unset( $parse_blocks[ $key ]['attrs']['quickLinksProfileLinksID'] );
					unset( $parse_blocks[ $key ]['attrs']['quickLinksTitle'] );
					unset( $parse_blocks[ $key ]['attrs']['quickLinksURL'] );
					unset( $parse_blocks[ $key ]['attrs']['quickLinksSelected'] );
					unset( $parse_blocks[ $key ]['attrs']['quickLinksIconURL'] );
					unset( $parse_blocks[ $key ]['attrs']['quickLinksIconValue'] );
					unset( $parse_blocks[ $key ]['attrs']['quickLinks'] );
					unset( $parse_blocks[ $key ]['attrs']['appPageID'] );
					unset( $parse_blocks[ $key ]['attrs']['appPageObj'] );
					unset( $parse_blocks[ $key ]['attrs']['coreMenuID'] );
					unset( $parse_blocks[ $key ]['attrs']['coreMenuObj'] );
				}
			}
			$new_content .= serialize_block( $parse_blocks[ $key ] );
		}

		return ! empty( $new_content ) ? $new_content : $content;
	}
}
