<?php

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

$current_menu = \BuddyBossApp\Menu::instance()->get_current_menu();
$current_menu = wp_doing_ajax() ? $_REQUEST['current_menu'] : $current_menu;
?>

<li id="menu-item-<?php echo esc_attr($menu_id); ?>"
    class="menu-item menu-item-depth-<?php echo $depth; ?> menu-item-page pending menu-item-edit-inactive">
    <div class="menu-item-bar">
        <div class="menu-item-handle">
                        <span class="item-title">
                            <span class="menu-item-title"><?php echo esc_attr($menu_label); ?></span>
                            <span class="menu-item-notlinked"
                                  style="color:red;font-weight: 100;font-size: 10px;display: block;margin-top: 0px;line-height: 10px;"><?php echo (!$linked) ? __("Item missing. Please reconfigure it from settings.", "buddyboss-app") : ""; ?></span>
                        </span>
            <span class="item-controls">
                        <span class="item-type"><?php echo esc_attr($menu_type_label); ?></span>
                        <a class="item-edit" id="edit-<?php echo esc_attr($menu_id); ?>"
                           href="#menu-item-settings-<?php echo esc_attr($menu_id); ?>"
                           aria-label="<?php echo esc_attr($menu_label); ?>"><span
                                    class="screen-reader-text"><?php echo esc_attr($menu_label); ?></span></a>
                    </span>
        </div>
    </div>

    <div class="menu-item-settings wp-clearfix" id="menu-item-settings-<?php echo esc_attr($menu_id); ?>">

        <p class="field-label description description-wide">
            <label for="edit-menu-item-label-<?php echo esc_attr($menu_id); ?>">
                <?php _e('Label', 'buddyboss-app') ?><br>
                <input type="text" id="edit-menu-item-label-<?php echo esc_attr($menu_id); ?>"
                       class="widefat edit-menu-item-label menu-item-data-label"
                       name="appmenu-item[<?php echo esc_attr($menu_id); ?>][label]"
                       value="<?php echo esc_attr($menu_label); ?>">
            </label>
        </p>

        <p class="field-css-classes description description-wide" style="display: none;">
            <label for="edit-menu-item-classes-<?php echo esc_attr($menu_id); ?>">
                <?php _e('Make it Section', 'buddyboss-app') ?>&nbsp;
                <input class="edit-menu-item-data-on appmenu-item-section" type="checkbox"
                       name="appmenu-item[<?php echo esc_attr($menu_id); ?>][section]" <?php checked(1, $menu_section) ?>
                       value="1">
            </label>
        </p>

        <?php if (in_array($menu_item['type'], array('custom','page'))) { ?>

            <p class="field-link description description-wide">
                <label for="edit-menu-item-link-<?php echo esc_attr( $menu_id ); ?>">
			        <?php _e( 'URL', 'buddyboss-app' ) ?><br>
                    <input type="text" id="edit-menu-item-link-<?php echo esc_attr( $menu_id ); ?>"
                           class="widefat edit-menu-item-link menu-item-data-link"
                           name="appmenu-item[<?php echo esc_attr( $menu_id ); ?>][data][link]"
				        <?php function_exists( 'wp_readonly' ) ? wp_readonly( 1, $is_readonly ) : readonly( 1, $is_readonly ); ?>
                           value="<?php echo esc_attr( $menu_url ); ?>">
                </label>
            </p>

        <?php } ?>

        <?php if (!in_array($menu_item['type'], array('section', 'app_page')) && 'more' === $current_menu ) { ?>

            <p class="field-open-external description">
                <input type="checkbox"
                        id="edit-menu-item-open-external-<?php echo esc_attr($menu_id); ?>"
                        name="appmenu-item[<?php echo esc_attr($menu_id); ?>][data][open_external]"
                    <?php checked($menu_open_external, "yes") ?>
                        value="yes">
                
                <label for="edit-menu-item-open-external-<?php echo esc_attr($menu_id); ?>">
                    <span class="item-open-external-text"><?php _e('Always open in external browser', 'buddyboss-app') ?><br></span>
                    <span>
						<?php
							printf( '%1$s <a href="%2$s">%3$s</a> %4$s',
								__( 'When enabled, this link will always open in an external browser, regardless of your', 'buddyboss-app' ),
								bbapp_get_admin_url( 'admin.php?page=bbapp-settings&setting=compatibility#app_settings_compatibility__link__header' ),
								__( 'Link Handling', 'buddyboss-app' ),
								__( 'preferences.', 'buddyboss-app' )
							);
						?>
					</span>
                </label>
            </p>

        <?php } ?>

        <?php if (!in_array($menu_item['type'], array('section', 'custom'))) { ?>

	        <?php do_action( 'bbapp_menu_feature', $menu_item, $menu_id ); ?>

        <?php } ?>

        <?php if ( ! in_array( $menu_item['type'], array( 'section' ) ) ){	?>
            <div>
                <?php
                /**
                 * Custom Settings.
                 * @var $class_name \BuddyBossApp\Menus\MenuAbstract
                 */
                $class_name = "\BuddyBossApp\Menus\\" . bbapp_camelize( $menu_item["name"] );

                if ( class_exists( $class_name ) ) {
                    $class_name::metabox( $menu_id, $menu_item );
                }

                ?>
            </div>
        <?php } ?>


        <?php if (!in_array($menu_item['type'], array('section'))) { ?>

            <div class="edit-menu-item-icon-container">
                <div class="edit-menu-item-icon">
                    <div class="bbapp_icon_picker_render bbapp_icon_picker"
                         data-field_name="<?php echo esc_attr( "appmenu-item[{$menu_id}][icon][uri]" ); ?>"
                         data-icon_url="<?php echo esc_html( $menu_ios_icon_uri ); ?>"
                         data-settings_field="<?php echo esc_html( "appmenu-item[{$menu_id}][icon][monochrome_setting]" ); ?>"
                         data-settings='<?php echo ( 1 !== $ios_monochrome_setting ) ? $ios_monochrome_setting : ''; ?>'
                         data-default_icon_color="<?php echo $ios_default_color; ?>"
                         data-reference_name="<?php echo esc_html( $menu_label ); ?>"
                         data-icon_style_id="<?php echo $ios_icon_style_id; ?>"
                         data-menu_screen="<?php echo esc_attr($menu_name); ?>"
                    ></div>
                    <label><?php _e( 'Icon', 'buddyboss-app' ) ?></label>
                </div>

            </div>

        <?php } ?>

        <?php if (!$linked) {
            $posts = get_posts(array("post_type" => $menu_type, 'numberposts' => -1));
            ?>
            <p><?php esc_attr_e("This menu item is connected to a missing item. Please select it below again.", "buddyboss-app"); ?></p>
            <p>
                <label for="edit-menu-item-search-<?php echo esc_attr($menu_id); ?>"><?php esc_attr_e("Select New Item", "buddyboss-app"); ?></label>
                <select name="appmenu-item[<?php echo esc_attr($menu_id); ?>][data][id]" class="widefat">
                    <option><?php esc_attr_e("Select New", "buddyboss-app"); ?></option>
                    <?php foreach ($posts as $post) { ?>
                        <option value="<?php echo esc_attr($post->ID); ?>"><?php echo esc_attr($post->post_title); ?></option>
                    <?php } ?>
                </select>
            </p>
        <?php } ?>


        <div class="menu-item-actions submitbox">
            <a class="item-delete submitdelete deletion" id="delete-<?php echo esc_attr($menu_id); ?>"
               href="#"><?php _e('Remove', 'buddyboss-app') ?></a> <span
                    class="meta-sep hide-if-no-js"> | </span> <a
                    class="item-cancel submitcancel hide-if-no-js"
                    id="cancel-<?php echo esc_attr($menu_id); ?>"
                    href="#"><?php _e('Cancel', 'buddyboss-app') ?></a>
        </div>

        <input class="menu-item-name" type="hidden"
               name="appmenu-item[<?php echo esc_attr($menu_id); ?>][name]"
               value="<?php echo esc_attr($menu_name); ?>">
        <?php if ($linked) { ?>
            <input class="menu-item-data-db-id" type="hidden"
                   name="appmenu-item[<?php echo esc_attr($menu_id); ?>][data][id]"
                   value="<?php echo esc_attr($menu_data_id); ?>">
        <?php } ?>
        <input class="menu-item-data-parent-id" type="hidden"
               name="appmenu-item[<?php echo esc_attr($menu_id); ?>][data][parent]"
               value="<?php echo esc_attr($menu_parent_id); ?>">
        <input class="menu-item-data-object" type="hidden"
               name="appmenu-item[<?php echo esc_attr($menu_id); ?>][type]"
               value="<?php echo esc_attr($menu_type); ?>">
    </div><!-- .menu-item-settings-->
    <ul class="menu-item-transport"></ul>
</li>

<script>

</script>