<?php
/**
 * Note: This is temp migration file. on the final merge of this repo on master this should be moved into dadicated migration plugin.
 */

namespace BuddyBossApp\Migration;

use BuddyBossApp\Helpers\BBAPP_File;
use BuddyBossApp\Helpers\File;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Typography' ) ) {
	class Typography {

		private static $instance;

		/**
		 * Get the instance of the class.
		 *
		 * @return Typography
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) ) {
				$class          = __CLASS__;
				self::$instance = new $class;
				self::$instance->_load();
			}

			return self::$instance;
		}

		/**
		 * Migrate constructor.
		 */
		public function __construct() {
		}

		/**
		 * Migrate load method.
		 */
		public function _load() {
			// this hook should load first.
			$this->rename_upload_folder();
			add_action( 'plugins_loaded', array( $this, 'migrate_load' ), 1 );
		}

		/**
		 * Migrate the options name.
		 */
		public function migrate_load() {
		}

		/**
		 * Migrate old typography fonts to new folder location.
		 */
		public function rename_upload_folder() {
			$upload_dir = wp_upload_dir();
			$dir_old    = $upload_dir["basedir"] . "/ab-fonts";
			$dir_new    = $upload_dir["basedir"] . "/bbapp/fonts";

			if ( bbapp_get_network_option( "bbapp_migrate_fonts_path" ) != "1" ) {

				if ( file_exists( $dir_old ) ) {
					BBAPP_File::create_dir($dir_new);
					BBAPP_File::copy_dir( $dir_old, $dir_new );
				}

				bbapp_set_network_option( "bbapp_migrate_fonts_path", "1" );
			}
		}
	}
}