<?php


namespace BuddyBossApp\Migration;
use BuddyBossApp\AppSettings;

if ( ! class_exists( 'Migrate' ) ) {

	class Settings {

		private static $instance;

		/**
		 * Get the instance of the class.
		 *
		 * @return Settings
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) ) {
				$class          = __CLASS__;
				self::$instance = new $class;
				self::$instance->_load();
			}

			return self::$instance;
		}

		/**
		 * Migrate constructor.
		 */
		public function __construct() {

		}

		public function plugins_loaded() {
			// Load them on order.
			$this->auth_setting_migrate_to_global_settings();
		}
		/**
		 * Migrate load method.
		 */
		public function _load() {
			add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ) );
		}

		/**
		 * Auth account setting migrate to global settings.
		 */
		public function auth_setting_migrate_to_global_settings() {
			$ab_migration = get_option( 'bbapp_migrate_app_auth_settings' );

			if ( "1" !== $ab_migration ) {
				$app_only = AppSettings::instance()->get_setting_value( "app_auth.enable_signup" );
				$settings = \BuddyBossApp\Admin\Settings::instance()->get_global_settings();
				if ( ! isset( $settings['app_auth.enable_signup'] ) ) {
					$settings['app_auth.enable_signup'] = $app_only;
				}
				if ( $auth_settings = get_option( '_ab_auth_account' ) ) {
					if ( isset( $auth_settings['email_activation_body'] ) ) {
						$settings['app_auth.email_activation_body'] = $auth_settings['email_activation_body'];
					}
				}
				if ( is_multisite() ) {
					if ( $auth_settings = get_network_option( 1, '_ab_auth_account' ) ) {
						if ( isset( $auth_settings['email_activation_body'] ) ) {
							$settings['app_auth.email_activation_body'] = $auth_settings['email_activation_body'];
						}
					}
				}

				\BuddyBossApp\Admin\Settings::instance()->save_global_settings( $settings );
				update_option( 'bbapp_migrate_app_auth_settings', "1" );
			}
		}
	}
}