<?php
/**
 * Note: This is temp migration file. on the final merge of this repo on master this should be moved into dadicated migration plugin.
 */

namespace BuddyBossApp\Migration;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Reporting' ) ) {
	class Reporting {

		private static $instance;

		/**
		 * Get the instance of the class.
		 *
		 * @return Reporting
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) ) {
				$class          = __CLASS__;
				self::$instance = new $class;
				self::$instance->_load();
			}

			return self::$instance;
		}

		/**
		 * Migrate constructor.
		 */
		public function __construct() {
		}

		/**
		 * Migrate load method.
		 */
		public function _load() {
            add_filter( 'bbapp_settings_rest_response', array( $this, 'addSettings' ) );
        }
        

        /**
         * @param $response
         *
         * @return mixed
         */
        public function addSettings( $response ){
            $json = ' {
                "user": {
                    "active": 0,
                    "reportable_items": [
                        "user"
                    ]
                },
                "forums": {
                    "active": 0,
                    "reportable_items": [
                        "topic",
                        "reply"
                    ]
                },
                "bp_activity": {
                    "active": 0,
                    "reportable_items": [
                        "bp_activity",
                        "bp_activity_comment"
                    ]
                }
            }';
            $response["moderation"] = json_decode($json); 
            return $response;
        }

    }

}
