<?php
/**
 * Note: This is temp migration file. on the final merge of this repo on master this should be moved into dadicated migration plugin.
 */

namespace BuddyBossApp\Migration;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'OptionsRename' ) ) {
	class OptionsRename {

		private static $instance;

		/**
		 * Get the instance of the class.
		 *
		 * @return optionsrenames
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) ) {
				$class          = __CLASS__;
				self::$instance = new $class;
				self::$instance->_load();
			}

			return self::$instance;
		}

		/**
		 * Migrate constructor.
		 */
		public function __construct() {
		}

		/**
		 * Migrate load method.
		 */
		public function _load() {
			// this hook should load first.
			add_action( 'plugins_loaded', array( $this, 'migrate_options_names' ), 1 );
		}

		/**
		 * Migrate the options name.
		 */
		public function migrate_options_names() {
			// Don't change the order to code execution as they are relative to each other.
			$this->rename_super_options_name();
			$this->rename_options_name();

		}

		/**
		 * Options available on normal wp & network admin on network wp.
		 *
		 */
		public function rename_super_options_name() {
			if ( bbapp_get_network_option( "bbapp_migrate_super_options_updated" ) != "1" ) {
				$options_names_map = array(
					"appboss_app_info"                => "bbapps",
					"_ab_auth_account"                => "bbapp_auth_settings",
					"appboss_iap_options"             => "bbapp_iap",
					"_ab_auth_social_logins_settings" => "bbapp_social_login_settings",
					"_ab_build_url_redirects"         => "bbapp_build_url_redirects",
					"_ab_builds"                      => "bbapp_builds",
				);
				foreach ( $options_names_map as $old_option_name => $new_option_name ) {
					$old_values = bbapp_get_network_option( $old_option_name );
					$new_values = bbapp_get_network_option( $new_option_name );
					if ( ! empty( $old_values ) && empty( $new_values ) ) {
						bbapp_set_network_option( $new_option_name, $old_values ); // Create new option name.
					}
				}
				bbapp_set_network_option( "bbapp_migrate_super_options_updated", "1" );
			}
		}

		/**
		 * Options available on normal wp or on each sub site.
		 */
		public function rename_options_name() {
			if ( get_option( "bbapp_migrate_options_updated" ) != "1" ) {
				$options_names_map = array(
					"appboss_app_languages"       => "bbapp_languages",
					"appboss_styling_options"     => "bbapp_styling",
					"appboss_typography_options"  => "bbapp_typography",
					"appboss_branding_options"    => "bbapp_branding",
					"appboss_app_settings"        => "bbapp_temp_settings",
					"appboss_push_archive_topics" => "bbapp_push_archive_topics",
				);
				foreach ( $options_names_map as $old_option_name => $new_option_name ) {
					$old_values = get_option( $old_option_name );
					$new_values = get_option( $new_option_name );
					if ( ! empty( $old_values ) && empty( $new_values ) ) {
						update_option( $new_option_name, $old_values ); // Create new option name.
					}
				}
				update_option( "bbapp_migrate_options_updated", "1" );
			}
		}
	}
}
