<?php

namespace BuddyBossApp\Migration\Notification;

/**
 * @deprecated
 * @todo :- Remove the rest API and convert it into dummy once all old codes are migrated.
 */

/**
 * Contain functionality for required additional rest api endpoints.
 * v1 Standard
 */
class RestAPI extends \WP_REST_Controller {

	protected $namespace_slug = '';
	protected $namespace      = 'appboss/core/v1';
	public static $instance;

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks();
		}

		return self::$instance;
	}

	public function hooks() {
		add_action( 'rest_api_init', array( $this, 'register_routes' ), 99 );
	}

	/**
	 * Register routes.
	 */
	public function register_routes() {

		register_rest_route(
			$this->namespace,
			'/notification',
			array(
				array(
					'methods'             => \WP_REST_Server::READABLE,
					'callback'            => array( $this, 'get_notifications' ),
					'permission_callback' => '__return_true',
					'args'                => array(),
				),
			)
		);

		register_rest_route(
			$this->namespace,
			'/notification/settings',
			array(
				array(
					'methods'             => \WP_REST_Server::READABLE,
					'callback'            => array( $this, 'get_notification_settings' ),
					'permission_callback' => '__return_true',
					'args'                => array(),
				),
				array(
					'methods'             => \WP_REST_Server::CREATABLE,
					'callback'            => array( $this, 'update_notification_settings' ),
					'permission_callback' => '__return_true',
					'args'                => array(),
				),
			)
		);
	}

	/**
	 * Notification settings.
	 *
	 * @param $request
	 * @apiPrivate
	 * @return \WP_Error|\WP_HTTP_Response|\WP_REST_Response
	 * @api {GET} /wp-json/appboss/core/v1/notification/settings Core notification settings
     * @apiName GetCoreNotificationSettings
     * @apiGroup CoreNotifications
     * @apiVersion 1.0.0
     * @apiPermission Public
     * @apiDescription Get core notification settings
	 */
	public function get_notification_settings( $request ) {
		global $wp_rest_server;

		$request_curl = new \WP_REST_Request( 'GET', '/buddyboss-app/core/v1/notification/settings' );
		$request_curl->set_query_params( $request->get_params() );
		$response = $this->dispatch( $request_curl );

		return $wp_rest_server->response_to_data( rest_ensure_response( $response ), isset( $request['_embed'] ) ? 1 : 0 );
	}

	/**
	 * Update notification settings.
	 *
	 * @param $request
	 * @apiPrivate
	 * @return \WP_Error|\WP_HTTP_Response|\WP_REST_Response
	 * @api {POST} /wp-json/appboss/core/v1/notification/settings Update core notification settings
     * @apiName UpdateCoreNotificationSettings
     * @apiGroup CoreNotifications
     * @apiVersion 1.0.0
     * @apiPermission Public
     * @apiDescription Update core notification settings
     */
	public function update_notification_settings( $request ) {
		global $wp_rest_server;

		$request_curl = new \WP_REST_Request( 'POST', '/buddyboss-app/core/v1/notification/settings' );
		$request_curl->set_body_params( $request->get_params() );
		$response = $this->dispatch( $request_curl );

		return $wp_rest_server->response_to_data( rest_ensure_response( $response ), isset( $request['_embed'] ) ? 1 : 0 );
	}

	/**
     * @apiPrivate
	 * @api {GET} /wp-json/appboss/core/v1/notification Core notification
	 * @apiName GetCoreNotification
	 * @apiGroup CoreNotifications
	 * @apiVersion 1.0.0
	 * @apiPermission Public
	 * @apiDescription Return Notifications Thought Rest API
	 * @apiHeader {String} accessToken Auth token
	 * @apiParam {String} unique_id App Id (also known as appid)
	 * @apiParam {String} [action='']
	 * @apiParam {Number{1-∞}} [page=1] Current page of the collection.
	 * @apiParam {Number{1-100}} [per_page=10] Maximum number of items to be returned in result set.
	 * @apiParam {Number} sitewide
	 * @apiParam {Number} [only_recent=false] How many results to show if only_recent is applied
	 */
	public function get_notifications( $request ) {
		global $wpdb, $bbapp_var;


		$args = array(
			'action'      => isset( $request['action'] ) && ! empty( $request['action'] ) ? $request['action'] : '',
			'page'        => isset( $request['page'] ) && ! empty( $request['page'] ) ? $request['page'] : 1,
			'per_page'    => isset( $request['per_page'] ) && ! empty( $request['per_page'] ) ? $request['per_page']
				: 10,
			'sitewide'    => $request['sitewide'],
			"only_recent" => isset( $request['only_recent'] ) ? intval( $request['only_recent'] ) : false,
			// only_recent is the value int how much result to show.
		);

		if ( is_user_logged_in() && function_exists( 'bbapp_notifications' ) ) {
			if ( $args['sitewide'] !== "1" ) {
				$args['only_recent'] = bbapp_notifications()->get_notification_count( get_current_user_id() );
			}
		}

		$args['user_id'] = isset( $args["sitewide"] ) && $args["sitewide"] == "1" ? 0 : get_current_user_id();

		//1. get sql query
		$sql = $this->_get_notifications_sql_query( $args );

		// add total count
		$count_sql     = "select count(*) as count from ( {$sql} ) x";
		$total_entries = (int) $wpdb->get_var( $count_sql );

		if ( empty( $sql ) ) {
			return array();
		}

		//2. Get results from db
		$notifications = $wpdb->get_results( $sql );
		if ( empty( $notifications ) || is_wp_error( $notifications ) ) {
			$notifications = array();
		}

		//3. Prepare results for api response

		//change cast
		$notifications = (array) $notifications;

		foreach ( $notifications as $key => $val ) {
			$notifications[ $key ] = (array) $val;
		}

		// adding collections
		foreach ( $notifications as $key => $val ) {
			$response              = $this->prepare_notifications_response( $val );
			$response              = apply_filters( 'bbapp_notification_api_response_entry', $response, $args );
			$notifications[ $key ] = $this->prepare_response_for_collection( $response );
		}

		do_action( "bbapp_notification_api_response_after", $notifications, $args, $request );

		//5. return response
		$response = rest_ensure_response( $notifications );

		$response->header( 'X-WP-Total', (int) $total_entries );

		return $response;

	}

	/**
	 * Dispatch the request item.
	 *
	 * @param $request
	 *
	 * @return mixed
	 */
	protected function dispatch( $request ) {

		$query_params = $request->get_params();

		if ( isset( $request->get_query_params()["_embed"] ) ) {
			$query_params["_embed"] = $request->get_query_params()["_embed"];
		}

		$request->set_query_params( $query_params );

		$server   = rest_get_server();
		$response = $server->dispatch( $request );

		return $response;
	}

	public function prepare_notifications_response( $val ) {

		$response = rest_ensure_response( $val );

		$uris = array();

		$uris[] = array( "author", rest_url( '/wp/v2/users/' . $val["author_id"] ) );

		if ( ! empty( $val["user_id"] ) && $val["user_id"] != $val["author_id"] ) {
			$uris[] = array( "author", rest_url( '/wp/v2/users/' . $val["user_id"] ) );
		}

		foreach ( $uris as $uri ) {
			$response->add_link( $uri[0], $uri[1], array( 'embeddable' => true ) );
		}

		return $response;

	}

	/**
	 * Generate the SQL Query for Notification
	 *
	 * @param array $args
	 *
	 * @return string the sql query
	 */
	protected function _get_notifications_sql_query( $args ) {

		global $wpdb;

		$where_clause = array();

		$settings_actions = array();

		if ( is_user_logged_in() ) {
			// get user push notification settings
			$actions = get_user_meta( get_current_user_id(), 'push_notification_settings', true );
			if ( ! is_array( $actions ) ) {
				$actions = json_decode( $actions, true );
			}
			if ( ! empty( $actions ) ) {
				foreach ( $actions as $key => $value ) {
					if ( ! $value ) {
						$settings_actions[] = $key;

						//Deprecated support for manual support
						if ( $key == 'manual_push_notification' ) {
							$settings_actions[] = 'manual_push';
						}
					}
				}
			}
		}

		if ( $args["action"] ) {
			$settings_actions = $args["action"];
		}

		/**
		 * Allow plugins to filter the notification output based on actions.
		 */
		$settings_actions = apply_filters( 'bbapp_push_notification_actions', $settings_actions );

		if ( ! empty( $settings_actions ) ) {
			$actions        = array_map( function ( $v ) {
				return "'" . esc_sql( $v ) . "'";
			}, $settings_actions );
			$actions        = implode( ',', $actions );
			$where_clause[] = "action NOT IN ( " . $actions . " )";
		}

		// filter by after
		if ( isset( $args["after"] ) ) {
			$args["after"]  = date( "Y-m-d H:i:s", strtotime( $args["after"] ) );
			$where_clause[] = $wpdb->prepare( " date_notified >= %s ", $args["after"] );
		}

		if ( isset( $args["user_id"] ) ) {
			$where_clause[] = $wpdb->prepare( " ( user_id = %d )", $args["user_id"] );
		}

		$where_clause[] = $wpdb->prepare( " blog_id = %d ", get_current_blog_id() );
		$where_clause[] = $wpdb->prepare( " version = %d ", 1 );

		$where_clause = implode( " AND ", $where_clause );

		if ( ! empty( $where_clause ) ) {
			$where_clause = "WHERE {$where_clause}";
		}

		$table = bbapp_get_network_table( 'bbapp_notifications' );

		$sql_queries = ( "SELECT
			`{$table}`.id as 'id',
			`{$table}`.date_notified as 'date_notified',
			`{$table}`.action as 'action',
			`{$table}`.user_id as 'user_id',
			`{$table}`.item_id as 'item_id',
			`{$table}`.author_id as 'author_id',
			`{$table}`.secondary_item_id as 'secondary_item_id',
			`{$table}`.primary_text as 'primary_text',
			`{$table}`.secondary_text as 'secondary_text',
		    `{$table}`.namespace AS 'namespace'
			FROM {$table} {$where_clause}" );

		$limit_clause = "";
		if ( ! empty( $args["per_page"] ) ) {

			$per_page   = intval( $args["per_page"] );
			$page       = max( $args["page"], 1 );
			$start_from = ( $page - 1 ) * $per_page;

			if ( ( ! is_numeric( $args["only_recent"] ) ) || ( is_numeric( $args["only_recent"] ) && $per_page < $args["only_recent"] ) ) {
				$limit_clause = "LIMIT {$start_from}, {$per_page}";
			} else {
				$args["only_recent"] = min( $args["only_recent"], 100 ); //keep 100 max so we don't crash db
				$limit_clause        = "LIMIT 0, {$args["only_recent"]}";
			}
		}

		return sprintf( "%s ORDER BY `date_notified` DESC, `id` DESC %s", $sql_queries, $limit_clause );
	}
}
