<?php

namespace BuddyBossApp\Migration\Notification;

use BuddyBossApp\Migration\Notification\RestAPI;
use BuddyBossApp\Migration\Notification\RestAPIv2;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Contains Features Related to Notifications & Push Notification.
 * Class Notification
 */
class PushNotification {
	private static $instance;

	function __construct() {
		/** Nothing here */
	}

	/**
	 * Get the instance of class
	 *
	 * @return Notification
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks(); // run the hooks.
		}

		return self::$instance;
	}

	protected function hooks() {
		if ( bbapp_is_active( 'push_notification' ) ) {
			// User Segments
			RestAPI::instance();
			RestAPIv2::instance();
		}
	}
}

