<?php

namespace BuddyBossApp\Migration;

// use BuddyBossApp\ClientCommon;
use BuddyBossApp\ManageApp;
use BuddyBossApp\RestErrors;


/**
 * @deprecated
 * @todo :- Remove the rest API and convert it into dummy once all old codes are migrated.
 */

/**
 * Contain functionality for required additional rest api endpoints.
 * v1 Standard
 */
class Notification extends \WP_REST_Controller {

	protected $namespace_slug = '';
	protected $namespace = "appboss/core/v1";
	public static $instance;

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks();
		}

		return self::$instance;
	}

	public function hooks() {
		add_action( 'rest_api_init', array( $this, "register_routes" ), 99 );
	}

	/**
	 * Register routes.
	 */
	public function register_routes() {

		register_rest_route( $this->namespace, '/notification/subscriptions', array(
			array(
				'methods'  => \WP_REST_Server::READABLE,
				'callback' => array( $this, 'get_notification_subscriptions' ),
				'args'     => array(),
				'permission_callback' => '__return_true',
			),
			array(
				'methods'  => \WP_REST_Server::CREATABLE,
				'callback' => array( $this, 'update_notification_subscriptions' ),
				'args'     => array(),
				'permission_callback' => '__return_true'
			)
		) );

	}

	/**
     * Notification settings.
     *
     * @param $request
     * @apiPrivate
     * @return \WP_Error|\WP_HTTP_Response|\WP_REST_Response
     * @api {GET} /wp-json/appboss/core/v1/notification/settings Core notification settings
	 * @apiName GetCoreNotificationSettings
	 * @apiGroup CoreNotifications
	 * @apiVersion 1.0.0
	 * @apiPermission LoggedInUser
	 * @apiDescription Get core notification settings
	 * @apiHeader {String} accessToken Auth token
	 * @apiParam {String} app_id App Id (also known as appid)
	 */
	public function get_notification_settings( $request ) {
		global $bbapp_var;

		/**
		 * Check user logged in permissions.
		 */
		if ( ! is_user_logged_in() ) {
			return RestErrors::instance()->user_not_logged_in();
		}

		$settings_list = $this->get_push_notification_subs_for_user( get_current_user_id() );

		$response = array();

		foreach ( $settings_list as $sub_name => $sub ) {
			$response[] = array_merge( array(
				"name" => $sub_name,
			), $sub );
		}

		return rest_ensure_response( $response );

	}

	/**
     * @apiPrivate
	 * @api {POST} /wp-json/appboss/core/v1/notification/subscriptions Update core notification subscriptions
	 * @apiName UpdateCoreNotificationSubscriptions
	 * @apiGroup CoreNotifications
	 * @apiVersion 1.0.0
	 * @apiPermission LoggedInUser
	 * @apiDescription Update Users Subscriptions.
	 * @apiHeader {String} accessToken Auth token
	 */
	public function update_notification_subscriptions( $request ) {
		global $bbapp_var;

		/**
		 * Check user logged in permissions.
		 */
		if ( ! is_user_logged_in() ) {
			return RestErrors::instance()->user_not_logged_in();
		}

		$subscription_list = $this->get_push_notification_subs_for_user( get_current_user_id() );

		$sub_data = \BuddyBossApp\Notification\Notification::instance()->get_push_notification_subs( get_current_user_id() );

		foreach ( $subscription_list as $sub_name => $sub ) {

			if ( isset( $request[ $sub_name ] ) && $sub["available"] ) {
				if ( $request[ $sub_name ] == "1" ) {
					$sub_data[ $sub_name ] = true;
				} else {
					$sub_data[ $sub_name ] = false;
				}
			}

		}

		\BuddyBossApp\Notification\Notification::instance()->update_push_notification_subs( get_current_user_id(), $sub_data );

		return $this->get_notification_subscriptions( $request );

	}

	/**
     * @apiPrivate
	 * @api {GET} /wp-json/appboss/core/v1/notification/subscriptions Core notification subscriptions
	 * @apiName GetCoreNotificationSubscriptions
	 * @apiGroup CoreNotifications
	 * @apiVersion 1.0.0
	 * @apiPermission LoggedInUser
	 * @apiDescription Return Users Subscriptions Lists
	 * @apiHeader {String} accessToken Auth token
	 * @apiParam {String} app_id App Id (also known as appid)
	 */
	public function get_notification_subscriptions( $request ) {
		global $bbapp_var;

		/**
		 * Check user logged in permissions.
		 */
		if ( ! is_user_logged_in() ) {
			return RestErrors::instance()->user_not_logged_in();
		}

		$subscription_list = $this->get_push_notification_subs_for_user( get_current_user_id() );

		$response = array();

		foreach ( $subscription_list as $sub_name => $sub ) {
			$response[] = array_merge( array(
				"name" => $sub_name,
			), $sub );
		}

		return rest_ensure_response( $response );

	}

	/**
	 * Return the notification subscription list for user.
	 *
	 * @param $bbapp_app_id
	 * @param $user_id
	 * @param bool $blog_id
	 *
	 * @return array
	 */
	function get_push_notification_subs_for_user( $user_id, $blog_id = false ) {

		if ( ! $blog_id ) {
			$blog_id = get_current_blog_id();
		}

		$bbapp_app_id = ManageApp::instance()->get_app_id();

		$subscriptions_lists = array();
		$subscriptions_settings_lists = \BuddyBossApp\Notification\Notification::instance()->get_push_notifications_subs_list();

		$subscriptions_settings_lists = apply_filters( "bbapp_get_notification_subscriptions_for_user", $subscriptions_settings_lists, $user_id );

		$user_data = \BuddyBossApp\Notification\Notification::instance()->get_push_notification_subs( $user_id );

		// Add the topic_id
		$changes = false;
		foreach ( $subscriptions_settings_lists as $subscriptions_settings_list ) {
			if ( $subscriptions_settings_list['settings'] ) {
				foreach ( $subscriptions_settings_list['settings'] as $setting_key => $subscriptions_setting ) {
					$subscriptions_lists[ $setting_key ] = $subscriptions_setting;
				}
			}
		}
		foreach ( $subscriptions_lists as $name => $value ) {

			if ( $value["is_topic"] ) {
				$value["topic"] = "{$bbapp_app_id}_{$name}_{$blog_id}";
			}

			$status = $subscriptions_lists[ $name ]["enabled"];

			if ( isset( $user_data[ $name ] ) ) {
				$status = $user_data[ $name ];
			} else {
				$changes            = true;
				$user_data[ $name ] = $status;
			}

			$value["enabled"] = (bool) $status;

			$subscriptions_lists[ $name ] = $value;

		}

		if ( $changes ) {
			\BuddyBossApp\Notification\Notification::instance()->update_push_notification_subs( $user_id, $user_data );
		}

		/**
		 * We keep all possible topics so we can disable them on app even when plugin remove them.
		 * This will be useful when some topic is subscribed by mobile and topic is removed on backend.
		 * In this case app will never know when to unsubscribe that topic, this feature will make app to unsubscribe.
		 * **/

		$all_topics = get_option( "bbapp_push_notifications_archive_topics" );

		if ( ! is_array( $all_topics ) ) {
			$all_topics = array();
		}

		$changes = false;

		// compare current topics with old.
		foreach ( $subscriptions_lists as $sub_name => $sub ) {
			if ( $sub["is_topic"] && ! isset( $all_topics[ $sub["topic"] ] ) ) {
				$all_topics[ $sub["topic"] ] = true;
				$changes                     = true;
			}
		}

		if ( $changes ) {
			update_option( "bbapp_push_notifications_archive_topics", $all_topics );
		}

		// Add back not available topics into list.
		$not_exists_topics = $all_topics;
		foreach ( $subscriptions_lists as $sub_name => $sub ) {
			if ( isset( $sub["topic"] ) && isset( $not_exists_topics[ $sub["topic"] ] ) ) {
				unset( $not_exists_topics[ $sub["topic"] ] );
			}
		}

		foreach ( $not_exists_topics as $topic_name => $tmp ) {
			$subscriptions_lists[ "deleted_" . $topic_name ] = array(
				"label"     => $topic_name,
				"enabled"   => false,
				"available" => false,
				"is_topic"  => true,
				"topic"     => $topic_name
			);
		}

		/**
		 * End Archive Topics Addition.
		 */

		return $subscriptions_lists;
	}

}