<?php
/**
 * Note: This is temp migration file. on the final merge of this repo on master this should be moved into dadicated migration plugin.
 */

namespace BuddyBossApp\Migration;

use BuddyBossApp\App\App;
use BuddyBossApp\ManageApp;
use BuddyBossApp\Memberships\BBAPPMemberships;
use BuddyBossApp\Migration\InAppPurchases\Controller;
use BuddyBossApp\Migration\Notification\PushNotification;
use BuddyBossApp\Notification\Push;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Migrate' ) ) {
	class Migrate {

		private static $instance;

		/**
		 * Get the instance of the class.
		 *
		 * @return Migrate
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) ) {
				$class          = __CLASS__;
				self::$instance = new $class;
				self::$instance->_load();
			}

			return self::$instance;
		}

		/**
		 * Migrate constructor.
		 */
		public function __construct() {
		}

		/**
		 * Migrate load method.
		 */
		public function _load() {

			add_action( "init", array( $this, "local_features" ) );

			OptionsRename::instance();
			AppMenu::instance();
			Menu::instance();
			MenuRest::instance();
			Notification::instance();
			Reporting::instance();
            Integrations::instance();
            IconPicker::instance();
			Branding::instance();
			Typography::instance();
			Build::instance();
			IAP::instance();
			RestApi::instance();
			if ( bbapp_is_active( 'iap' ) ) {
				Controller::instance();
			}
			Memberships::instance();
			MetaApi::instance();
			PushNotification::instance();
			DeepLinking::instance();
     		// Migration for the authentication apis.
			Auth::instance();
			Settings::instance();
			// Load bbPress Core API [ Deprecated ]
			new \BuddyBossApp\Api\BbPress\Main();
			// Load BuddyPress Core API [ Deprecated ]
			new \BuddyBossApp\Api\BuddyPress\Main();
			// Load Learner [ Deprecated ]
			\BuddyBossApp\Api\Learner\Main::instance();
			// Load Learner LearnDash API [ Deprecated ]
			\BuddyBossApp\Api\Learner\LearnDash\Main::instance();
			// Load Learndash API - Support
			\BuddyBossApp\Migration\LearnDash\Main::instance();

			// Memberships
			// -----------------------------------------------------------------------------
			BBAPPMemberships::instance();

			add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ) );
		}

		public function plugins_loaded(){
			$this->bbapp_remove_app_id_index();
			$this->bbapp_rename_database_tables();
		}

		/**
		 * Add location features related to social features.
		 */
		public function local_features() {
			// @todo: Should be remove in future.
			App::instance()->add_local_feature( "learner_app", array(
				"is_enabled_android" => defined( 'LEARNDASH_VERSION' ),
				"is_enabled_ios"     => defined( 'LEARNDASH_VERSION' ),
			) );
		}

		/**
		 * Remove app id from below options.
		 */
		public function bbapp_remove_app_id_index() {
			$current_app_id = $this->get_app_id();

			$bbapp_migration = get_option( 'bbapp_remove_app_id_migration' );
			if ( "1" !== $bbapp_migration ) {
				$app_ids_options = array(
					'bbapp_languages',
					'bbapp_branding',
					'bbapp_temp_settings',
					'bbapp_styling',
					'bbapp_typography',
					'bbapp_builds',
					'bbapps',
				);

				foreach ( $app_ids_options as $app_ids_option ) {
					$app_option_data = get_option( $app_ids_option );
					update_option( '_migration_' . $app_ids_option, $app_option_data );

					if ( 'bbapp_temp_settings' === $app_ids_option ) {
						if ( ! empty( $app_option_data ) ) {
							if ( isset( $app_option_data[ $current_app_id ] ) && ! empty( $app_option_data[ $current_app_id ] ) ) {
								$bbapp_menus = get_option( 'bbapp_menus' );
								if ( empty( $bbapp_menus ) ) {
									update_option( $app_ids_option, $app_option_data[ $current_app_id ] );
								}
							}
						}
					} else if ( 'bbapps' === $app_ids_option ) {
						if ( isset( $app_option_data[ $current_app_id ] ) ) {
							$final_data      = $app_option_data[ $current_app_id ];
							$app_option_data = array_merge( $app_option_data, $final_data );
							unset( $app_option_data[ $current_app_id ] );
							$app_option_data['bbapp_app_id']    = $app_option_data['ab_app_id'];
							$app_option_data['bbapp_app_name']  = $app_option_data['ab_app_name'];
							unset( $app_option_data['verified'] );
							unset( $app_option_data['bbapp_app_key'] );
							unset( $app_option_data['bbapp_site_type'] );
							update_option( $app_ids_option, $app_option_data );
						}
					} else if ( 'bbapp_typography' === $app_ids_option ) {
						if ( isset( $app_option_data[ $current_app_id ] ) ) {
							$final_typography_data = $app_option_data[ $current_app_id ];
							$font_scales_data      = $app_option_data['font_scales'];
							unset( $app_option_data['font_scales'] );
							unset( $app_option_data[ $current_app_id ] );
							$app_option_data = array_merge( $app_option_data, $final_typography_data );
							update_option( 'bbapp_typography_font_scales', $font_scales_data );
							update_option( $app_ids_option, $app_option_data );
						}
					} else {
						if ( isset( $app_option_data[ $current_app_id ] ) ) {
							$final_data      = $app_option_data[ $current_app_id ];
							$app_option_data = array_merge( $app_option_data, $final_data );
							unset( $app_option_data[ $current_app_id ] );

							update_option( $app_ids_option, $app_option_data );
						}
					}
				}
				update_option( 'bbapp_remove_app_id_migration', "1" );
			}
		}


		/**
		 * Get app id.
		 * @return false|mixed
		 */
		public function get_app_id() {
			$app = $this->get_app();

			if ( is_array( $app ) ) {
				return isset( $app["app_id"] ) ? $app["app_id"] : false;
			}

			return $app;
		}

		/**
		 * Get apps.
		 * @return false|mixed
		 */
		public function get_app() {
			$apps = ManageApp::instance()->get_app();
			if ( isset( $apps["app_id"] ) ) {
				return $apps["app_id"];
			}
			foreach ( $apps as $app ) {
				return $app;
			}

			return false;
		}

		/**
		 * Rename database table appb to bbapp.
		 */
		public function bbapp_rename_database_tables() {
			$bbapp_migration = get_option( 'bbapp_rename_table_name_migration' );
			if ( "1" !== $bbapp_migration ) {
				global $wpdb;

				$charset_collate = $wpdb->get_charset_collate();

				require_once ABSPATH . 'wp-admin/includes/upgrade.php';

				$table_lists = array(
					'appb_notifications_devices'   => 'bbapp_user_devices',
					'appb_iap_ordermeta'           => 'bbapp_iap_ordermeta',
					'appb_iap_orders'              => 'bbapp_iap_orders',
					'appb_iap_products'            => 'bbapp_iap_products',
					'appb_itemmeta'                => 'bbapp_itemmeta',
					'appb_logs'                    => 'bbapp_logs',
					'appb_notifications'           => 'bbapp_notifications',
					'appb_push_notifications'      => 'bbapp_push_notifications',
					'appb_push_notifications_meta' => 'bbapp_push_notifications_meta',
					'appb_push_queue'              => 'bbapp_push_queue',
					'appb_queue'                   => 'bbapp_queue',
					'appb_user_segment'            => 'bbapp_user_segment',
				);

				$remove_app_id_from = array(
					'bbapp_user_devices' => array(
						'create_sql'   => "CREATE TABLE {$wpdb->prefix}bbapp_user_devices (
            id bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            user_id bigint(20) NOT NULL,
            device_token varchar(500) NOT NULL,
            device_token_hash varchar(70) NOT NULL,
            auth_token_hash varchar(70) NOT NULL,
            platform varchar(10) NOT NULL,
            app_ver varchar(12) NOT NULL,
            push_type varchar(20) NOT NULL,
            data longtext DEFAULT NULL,
            date_updated datetime DEFAULT '0000-00-00 00:00:00' NULL,
            KEY device_token_hash (device_token_hash),
            KEY auth_token_hash (auth_token_hash),
            KEY user_id (user_id),
            KEY date_updated (date_updated),
            KEY app_ver (app_ver),
            KEY push_type (push_type)
        ) {$charset_collate}",
						'insert_field' => "id, user_id,device_token,device_token_hash,auth_token_hash,platform,app_ver,push_type,data,date_updated,"
					),
					'bbapp_push_notifications'    => array(
						'create_sql'   => "CREATE TABLE {$wpdb->prefix}bbapp_push_notifications (
            id bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            action varchar(30) NOT NULL,
            primary_text varchar(500) NOT NULL,
            secondary_text varchar(500) DEFAULT NULL,
            target_type varchar(30) DEFAULT NULL,
            target bigint(20) DEFAULT NULL,
            sent_as bigint(20) DEFAULT 0,
            data longtext DEFAULT NULL,
            agent varchar(100) DEFAULT 'event' NULL,
            status varchar(100) DEFAULT 'sent' NULL,
            is_schedule tinyint(1) DEFAULT '0' NULL,
            date_schedule datetime DEFAULT '0000-00-00 00:00:00' NULL,
            date_expire datetime DEFAULT '0000-00-00 00:00:00' NULL,
            date_updated datetime DEFAULT '0000-00-00 00:00:00' NULL,
            date_created datetime DEFAULT '0000-00-00 00:00:00' NULL,
            blog_id bigint(20) NOT NULL,
            KEY target (target),
            KEY date_created (date_created),
            KEY date_updated (date_updated),
            KEY is_schedule (is_schedule),
            KEY date_expire (date_expire),
            KEY sent_as (sent_as),
            KEY agent (agent)
        ) {$charset_collate}",
						'insert_field' => "id, action, primary_text, secondary_text, target_type, target, sent_as, data, agent, status, is_schedule, date_schedule, date_expire, date_updated, date_created, blog_id"
					),
					'bbapp_push_queue'            => array(
						'create_sql'   => "CREATE TABLE {$wpdb->prefix}bbapp_push_queue (
            id bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            n_id bigint(20) NOT NULL,
            created datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
            device text DEFAULT NULL,
            unique_hash varchar(100) NOT NULL,
            user_id bigint(20) NOT NULL,
            agent varchar(50) NOT NULL,
            data text DEFAULT NULL,
            priority tinyint(2) NOT NULL,
            sent tinyint(1) NOT NULL,
            KEY created (created),
            KEY unique_hash (unique_hash),
            KEY user_id (user_id),
            KEY agent (agent),
            KEY priority (priority),
            KEY sent (sent)
        ) $charset_collate;",
						'insert_field' => "id, created, device, unique_hash, user_id, agent,data,priority,sent"
					),

				);
				$update_app_id_from   = array(
					'bbapp_iap_orders',

				);
				$alter_sql_list       = array();
				$change_column_sql_list = array();
				$create_new_sql_list = array();
				$rename_column_sql_list = array();
				$insert_new_sql_list = array();
				$delete_old_sql_list = array();

				foreach ( $table_lists as $old_table_name => $new_table_name ) {

					$prefix_new_table_name = $wpdb->prefix . $new_table_name;
					$prefix_old_table_name = $wpdb->prefix . $old_table_name;
					if ( $wpdb->query( "SELECT * FROM information_schema.tables WHERE table_schema = '{$wpdb->dbname}' AND table_name = '{$prefix_old_table_name}' LIMIT 1;" ) ) {

						if ( ! $wpdb->query( "SELECT 1 FROM  {$prefix_new_table_name}" ) ) {
							$alter_sql_list[] = "ALTER TABLE {$prefix_old_table_name} RENAME TO {$prefix_new_table_name}";
						}

						// TODO: app_id should be remove manually.
						if ( array_key_exists( $new_table_name, $remove_app_id_from ) ) {
							if ( $wpdb->query( "SHOW COLUMNS from {$prefix_old_table_name} LIKE 'app_id'" ) ) {
								$make_old                 = $prefix_new_table_name . '_old';
								$rename_column_sql_list[] = "ALTER TABLE {$prefix_new_table_name} RENAME TO {$make_old};";
								$create_new_sql_list[]    = $remove_app_id_from[ $new_table_name ]['create_sql'];
								$insert_field             = $remove_app_id_from[ $new_table_name ]['insert_field'];
								$insert_new_sql_list[]    = "INSERT INTO {$prefix_new_table_name} ({$insert_field}) SELECT {$insert_field} FROM {$make_old};";
								$delete_old_sql_list[]    = "DROP TABLE  {$make_old};";
							}
						}

						if ( in_array( $new_table_name, $update_app_id_from ) ) {
							if ( $wpdb->query( "SHOW COLUMNS from {$prefix_old_table_name} LIKE 'appboss_product_id'" ) ) {
								$change_column_sql_list[] = "ALTER TABLE {$prefix_new_table_name} CHANGE COLUMN appboss_product_id bbapp_product_id bigint(20);";
							}
						}
					}
				}


				if ( ! empty( $alter_sql_list ) ) {
					foreach ( $alter_sql_list as $alter_sql ) {
						$wpdb->query( $alter_sql );
					}
				}
				if ( ! empty( $rename_column_sql_list ) ) {
					foreach ( $rename_column_sql_list as $rename_column_sql ) {
						$wpdb->query( $rename_column_sql );
					}
				}

				if ( ! empty( $create_new_sql_list ) ) {
					foreach ( $create_new_sql_list as $create_new_sql ) {
						dbDelta( $create_new_sql );
					}
				}

				if ( ! empty( $insert_new_sql_list ) ) {
					foreach ( $insert_new_sql_list as $insert_new_sql ) {
						$wpdb->query( $insert_new_sql );
					}
				}

				if ( ! empty( $delete_old_sql_list ) ) {
					foreach ( $delete_old_sql_list as $delete_old_sql ) {
						$wpdb->query( $delete_old_sql );
					}
				}

				if ( ! empty( $change_column_sql_list ) ) {
					foreach ( $change_column_sql_list as $change_column_sql ) {
						$wpdb->query( $change_column_sql );
					}
				}

				update_option( 'bbapp_rename_table_name_migration', "1" );
			}
		}
	}
}
