<?php


namespace BuddyBossApp\Migration;

use BuddyBossApp\Migration\AppMenu;

class MenuRest {
	protected $namespace = "appboss/core/v1";
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return MenuRest
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->_load();
		}

		return self::$instance;
	}

	/**
	 * Migrate constructor.
	 */
	public function __construct() {
	}

	/**
	 * Migrate load method.
	 */
	public function _load() {
		add_action( 'rest_api_init', array( $this, "register_routes" ), 99 );
	}

	/**
	 * Register wordpress endpoint routes.
	 */
	public function register_routes() {
		register_rest_route( $this->namespace, '/menu_settings/(?P<app_id>[a-zA-Z0-9-]+)', array(
			array(
				'methods'  => \WP_REST_Server::READABLE,
				'callback' => array( $this, 'menu_settings' ),
				'permission_callback' => '__return_true',
			),
		) );
	}

	/**
	 * @param $request
	 * @apiPrivate
	 * @return mixed
	 * @api {GET} /wp-json/appboss/core/v1/menu_settings/:app_id Menu settings
	 * @apiName CoreMenuSettings
	 * @apiGroup CoreSettings
	 * @apiVersion 1.0.0
	 * @apiPermission Public
	 * @apiDescription Core menu settings
	 * @apiParam {String} app_id App Id
	 * @apiUse apidocForCoreMenuSettingsV1
	 */
	public function menu_settings( $request ) {
		$appmenu = AppMenu::instance();

		return $appmenu->rest_response( $request );
	}
}