<?php
/**
 * Note: This is temp migration file. on the final merge of this repo on master this should be moved into dadicated migration plugin.
 */

namespace BuddyBossApp\Migration;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Migrate' ) ) {
	class Menu {

		private static $instance;

		/**
		 * Temp key.
		 */
		private static $temp_key = 'bbapp_temp_settings';

		/**
		 * Get the instance of the class.
		 *
		 * @return Menu
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) ) {
				$class          = __CLASS__;
				self::$instance = new $class;
				self::$instance->_load();
			}

			return self::$instance;
		}

		/**
		 * Migrate constructor.
		 */
		public function __construct() {
			add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ) );
		}

		public function plugins_loaded(){
		}

		/**
		 * Migrate load method.
		 */
		public function _load() {
			AppMenu::instance();
			MenuRest::instance();
			add_filter( "rest_post_dispatch", array( $this, "modify_menu_response_for_current_app" ), 10, 3 );
		}

		/**
		 * Modify menu response until new changes not merged in app.
		 *
		 * @param $response
		 * @param $handler
		 * @param $request
		 *
		 * @return mixed
		 */
		public function modify_menu_response_for_current_app( $response, $handler, $request ) {

			if ( strstr( $response->get_matched_route(), "appboss/core/v1/menu_settings/" ) ) {

				$menus = $response->data;
				foreach ( $menus as $key => $menu ) {
					if ( 'section' === $menu['type'] ) {
						if ( ! empty( $menu['section'] ) ) {
							foreach ( $menu['section'] as $section_key => $section ) {
								$menu['section'][ $section_key ]['icon']['ios_uri']            = $section['icon']['uri'];
								$menu['section'][ $section_key ]['icon']['ios_icon_style']     = $section['icon']['icon_style'];
								$menu['section'][ $section_key ]['icon']['ios_tint_color']     = $section['icon']['tint_color'];
								$menu['section'][ $section_key ]['icon']['ios_uri_value']      = $section['icon']['uri_value'];
								$menu['section'][ $section_key ]['icon']['android_uri']        = $section['icon']['uri'];
								$menu['section'][ $section_key ]['icon']['android_icon_style'] = $section['icon']['icon_style'];
								$menu['section'][ $section_key ]['icon']['android_tint_color'] = $section['icon']['tint_color'];
								$menu['section'][ $section_key ]['icon']['android_url_value']  = $section['icon']['uri_value'];
							}
							$menus[ $key ] = $menu;
						}
					} else {
						$menus[ $key ]['icon']['ios_uri']            = $menu['icon']['uri'];
						$menus[ $key ]['icon']['ios_icon_style']     = $menu['icon']['icon_style'];
						$menus[ $key ]['icon']['ios_tint_color']     = $menu['icon']['tint_color'];
						$menus[ $key ]['icon']['ios_uri_value']      = $menu['icon']['uri_value'];
						$menus[ $key ]['icon']['android_uri']        = $menu['icon']['uri'];
						$menus[ $key ]['icon']['android_icon_style'] = $menu['icon']['icon_style'];
						$menus[ $key ]['icon']['android_tint_color'] = $menu['icon']['tint_color'];
						$menus[ $key ]['icon']['android_url_value']  = $menu['icon']['uri_value'];
					}
				}
				$response->data = $menus;
			}

			return $response;
		}

		/**
		 * No not modify nature of below code. as they won't be executed on already run sites.
		 * If you want to modify write a new function.
		 */
		public function menu_migration_section_id_parent() {
			$bbapp_migration = get_option( 'bbapp_mgration_section_id_and_parent' );
			if ( ! $bbapp_migration ) {
				$app_settings = get_option( self::$temp_key );
				/**
				 * Section menu and other tab bar menu.
				 */
				if ( isset( $app_settings['menu'] ) && ! empty( $app_settings['menu'] ) ) {
					foreach ( $app_settings['menu']['more'] as $key => $menus ) {
						if ( 'section' === $menus['object'] ) {
							if ( isset( $menus['section'] ) && ! empty( $menus['section'] ) ) {
								foreach ( $menus['section'] as $section_key => $section_menus ) {
									$app_settings['menu']['more'][ $key ]['section'][ $section_key ]['data']['parent'] = $menus['id'];
								}
							}
						}
					}
					update_option( self::$temp_key, $app_settings );
				}
				update_option( 'bbapp_mgration_section_id_and_parent', "1" );
				$this->menu_migration_type_to_object();
			}
		}

		/**
		 * No not modify nature of below code. as they won't be executed on already run sites.
		 * If you want to modify write a new function.
		 *
		 * This script run for app_page and page both type to make object.
		 */
		public function menu_migration_type_to_object() {
			$bbapp_migration = get_option( 'bbapp_migrate_type' );
			if ( ! $bbapp_migration ) {
				$app_settings = get_option( self::$temp_key );
				if ( isset( $app_settings['menu'] ) && ! empty( $app_settings['menu'] ) ) {
					/**
					 * Section menu and other tab bar menu.
					 */
					foreach ( $app_settings['menu'] as $key => $menus ) {
						if ( 'tabbar' === $key ) {
							foreach ( $menus as $m_key => $menu ) {

								if ( in_array( $menu['type'], array( 'app_page', 'page' ) ) ) {
									$app_settings['menu'][ $key ][ $m_key ]['type']   = 'post_type';
									$app_settings['menu'][ $key ][ $m_key ]['object'] = $menu['type'];
								}
							}
						}
						if ( 'more' === $key ) {
							foreach ( $menus as $m_key => $menu ) {
								if ( isset( $menu['type'] ) ) {
									if ( 'section' === $menu['type'] ) {
										if ( ! empty( $menu['section'] ) ) {
											foreach ( $menu['section'] as $section_key => $section ) {
												if ( in_array( $section['type'], array( 'app_page', 'page' ) ) ) {
													$app_settings['menu'][ $key ][ $m_key ]['section'][ $section_key ]['type']   = 'post_type';
													$app_settings['menu'][ $key ][ $m_key ]['section'][ $section_key ]['object'] = $section['type'];
												}
											}
										}
									} else {
										if ( in_array( $menu['type'], array( 'app_page', 'page' ) ) ) {
											$app_settings['menu'][ $key ][ $m_key ]['type']   = 'post_type';
											$app_settings['menu'][ $key ][ $m_key ]['object'] = $menu['type'];
										}
									}
								}
							}
						}
					}

					update_option( self::$temp_key, $app_settings );
				}
				update_option( 'bbapp_migrate_type', "1" );
				$this->menu_migration_remove_bbapp_from_icon_picker_setting();
			}
		}

		/**
		 * No not modify nature of below code. as they won't be executed on already run sites.
		 * If you want to modify write a new function.
		 *
		 * This script run for app_page and page both type to make object.
		 */
		public function menu_migration_remove_bbapp_from_icon_picker_setting() {

			$bbapp_migration = get_option( 'bbapp_migrate_remove_ab_from_icon_picker' );

			if ( ! $bbapp_migration ) {
				$app_settings = get_option( self::$temp_key );
				if ( ! empty( $app_settings ) ) {
					update_option( "bbapp_migrate_setting_old_data", $app_settings );
					if ( isset( $app_settings['settings']['app_menu.tabbar_more_menu_icon_android'] ) ) {
						$monochrome_setting = $app_settings['settings']['app_menu.tabbar_more_menu_icon_android']['monochrome_setting'];
						if ( isset( $monochrome_setting ) && ! empty( $monochrome_setting ) ) {
							$monochrome_setting                                                                       = str_replace( 'bbapp_', '', $monochrome_setting );
							$app_settings['settings']['app_menu.tabbar_more_menu_icon_android']['monochrome_setting'] = $monochrome_setting;
						}
					}

					if ( isset( $app_settings['menu'] ) && ! empty( $app_settings['menu'] ) ) {
						/**
						 * Section menu and other tab bar menu.
						 */
						foreach ( $app_settings['menu'] as $key => $menus ) {
							if ( 'tabbar' === $key ) {
								foreach ( $menus as $m_key => $menu ) {
									if ( isset( $menu['icon'] ) ) {
										$monochrome_setting = $app_settings['menu'][ $key ][ $m_key ]['icon']['monochrome_setting'];
										if ( isset( $monochrome_setting ) && ! empty( $monochrome_setting ) ) {
											$monochrome_setting = str_replace( 'ab_', '', $monochrome_setting );

											$app_settings['menu'][ $key ][ $m_key ]['icon']['monochrome_setting'] = $monochrome_setting;
										}
									}
								}
							}
							if ( 'more' === $key ) {
								foreach ( $menus as $m_key => $menu ) {
									if ( isset( $menu['type'] ) ) {
										if ( 'section' === $menu['type'] ) {
											if ( ! empty( $menu['section'] ) ) {
												foreach ( $menu['section'] as $section_key => $section ) {

													if ( isset( $section['icon'] ) ) {
														$monochrome_setting = $app_settings['menu'][ $key ][ $m_key ]['section'][ $section_key ]['icon']['monochrome_setting'];
														if ( isset( $monochrome_setting ) && ! empty( $monochrome_setting ) ) {
															$monochrome_setting = str_replace( 'ab_', '', $monochrome_setting );

															$app_settings['menu'][ $key ][ $m_key ]['section'][ $section_key ]['icon']['monochrome_setting'] = $monochrome_setting;
														}
													}
												}
											}
										} else {
											if ( isset( $menu['icon'] ) ) {
												$monochrome_setting = $app_settings['menu'][ $key ][ $m_key ]['icon']['monochrome_setting'];
												if ( isset( $monochrome_setting ) && ! empty( $monochrome_setting ) ) {
													$monochrome_setting = str_replace( 'ab_', '', $monochrome_setting );

													$app_settings['menu'][ $key ][ $m_key ]['icon']['monochrome_setting'] = $monochrome_setting;
												}
											}
										}
									}
								}
							}
						}
					}

					if ( ! empty( $app_settings['menu_settings'] ) ) {
						foreach ( $app_settings['menu_settings'] as $key => $menu ) {

							if ( 'section' === $menu['type'] ) {
								if ( ! empty( $menu['section'] ) ) {
									foreach ( $menu['section'] as $section_key => $section ) {
										if ( isset( $section['icon']['monochrome_setting'] ) ) {
											$monochrome_setting = $app_settings['menu_settings'][ $key ]['section'][ $section_key ]['icon']['monochrome_setting'];
											$monochrome_setting = str_replace( 'ab_', '', $monochrome_setting );

											$app_settings['menu_settings'][ $key ]['section'][ $section_key ]['icon']['monochrome_setting'] = $monochrome_setting;
										}
									}
								}
							} else {
								$monochrome_setting = $app_settings['menu_settings'][ $key ]['icon']['monochrome_setting'];
								if ( isset( $monochrome_setting ) && ! empty( $monochrome_setting ) ) {
									$monochrome_setting = str_replace( 'ab_', '', $monochrome_setting );

									$app_settings['menu_settings'][ $key ]['icon']['monochrome_setting'] = $monochrome_setting;
								}
							}
						}

						update_option( self::$temp_key, $app_settings );
						update_option( 'bbapp_migrate_remove_ab_from_icon_picker', "1" );
						$this->menu_migration_separate_menu_types();
					}
				}
			}
		}

		/**
		 * No not modify nature of below code. as they won't be executed on already run sites.
		 * If you want to modify write a new function.
		 */
		public function menu_migration_separate_menu_types() {
			$bbapp_migration = get_option( 'bbapp_mgration_separate_menu_types' );
			if ( ! $bbapp_migration ) {
				$app_settings = get_option( self::$temp_key );

				// don't do anything if it's already migrated.
				if ( isset( $app_settings["settings"] ) && ! empty( $app_settings["settings"] ) ) {
					// Icon style setting.
					$tabbar_labels = $app_settings["settings"]["app_menu.appmenu_labels_ios"];
					unset( $app_settings["settings"]["app_menu.appmenu_labels_ios"] );
					$app_settings["settings"]["app_menu.appmenu_labels"] = $tabbar_labels;

					$app_settings['menu'] = array(
						'tabbar' => array(),
						'more'   => array(),
					);

					/**
					 * Section menu and other tab bar menu.
					 */
					if ( isset( $app_settings['menu_settings'] ) ) {
						foreach ( $app_settings['menu_settings'] as $index => $menu ) {
							if ( $index < 4 ) {
								if ( ! isset( $menu['section'] ) ) {
									$app_settings['menu']['tabbar'][ $index ] = $this->create_menu_item_format( $menu, $index );
								}
							} else { // more

								if ( ! empty( $menu['section'] ) && is_array( $menu['section'] ) ) {
									$section_item             = array();
									$section_item['label']    = $menu['label'];
									$section_item['original'] = $menu['label'];
									$section_item['id']       = isset( $menu['id'] ) ? $menu['id'] : $menu['data']['id'];
									$section_item['object']   = $menu['name'];
									$section_item['data']     = $menu['data'];
									$section_item['type']     = $menu['type'];
									foreach ( $menu['section'] as $section_index => $m_item ) {
										$section_item['section'][ $section_index ] = $this->create_menu_item_format( $m_item, $section_index );
									}
									$app_settings['menu']['more'][ $index ] = $section_item;
								} else {
									$app_settings['menu']['more'][ $index ] = $this->create_menu_item_format( $menu, $index );
								}
							}
						}
					}

					$app_settings['menu']['more'] = array_values( $app_settings['menu']['more'] );
					update_option( self::$temp_key, $app_settings );
					update_option( 'bbapp_menus', $app_settings['menu'] );
					$this->bbapp_menu_complete_step();
				}
				update_option( 'bbapp_mgration_separate_menu_types', "1" );
			}
		}

		/**
		 * Function will remove temp settings from DB.
		 *
		 */
		public function bbapp_menu_complete_step() {
			delete_option( self::$temp_key );
			delete_option( '_migration_bbapp_temp_settings' );
			$app_settings = \BuddyBossApp\ManageApp::instance()->get_app_settings();
			if ( empty( $app_settings ) ) {
				\BuddyBossApp\ManageApp::instance()->update_app_settings( $app_settings['settings'] );
			} else {
				\BuddyBossApp\ManageApp::instance()->update_app_settings( array_merge( $app_settings['settings'], $app_settings ) );
			}
		}

		/**
		 * Create menu item.
		 *
		 * @param $menu
		 * @param $index
		 *
		 * @return array
		 */
		public function create_menu_item_format( $menu, $index ) {

			$menu_item = array(
				"id"       => isset( $menu['id'] ) ? $menu['id'] : uniqid(),
				"original" => isset( $menu['original'] ) ? $menu['original'] : $menu['label'],
				"label"    => $menu['label'],
				"type"     => $menu['type'],
				"object"   => isset( $menu['name'] ) ? $menu['name'] : $menu['object'],
				'data'     => array(
					'id'     => ! empty( $menu['data']['id'] ) ? $menu['data']['id'] : $menu['type'],
					'parent' => isset( $menu['data']['parent'] ) ? $menu['data']['parent'] : $index,
				),
				"icon"     => array(
					'uri'                => ! empty( $menu['icon']['uri'] ) ? $menu['icon']['uri'] : '',
					"monochrome_setting" => ! empty( $menu['icon']['monochrome_setting'] ) ? $menu['icon']['monochrome_setting'] : '',
					'icon_style'         => ! empty( $menu['icon']['icon_style'] ) ? $menu['icon']['icon_style'] : 'filled',
				),
			);

			if ( 'app_page' === $menu['type'] ) {
				$menu_item['type']   = 'post_type';
				$menu_item['object'] = $menu['type'];
			}
			if ( 'core' !== $menu_item['type'] ) {
				$menu_item['data']['link'] = ! empty( $menu['data']['link'] ) ? $menu['data']['link'] : '';
			}

			return $menu_item;
		}

	}
}