<?php

namespace BuddyBossApp\Migration\LearnDash\V1\User;
class UserRest {

	protected static $instance;

	/**
	 * UserRest constructor.
	 */
	public function __construct() {
		add_filter( 'rest_user_query', array( $this, 'filter_teachers' ), 10, 2 );
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
		}

		return self::$instance;
	}

	/**
	 * @param $prepared_args
	 * @param $request
	 *
	 * @return mixed
	 */
	public function filter_teachers( $prepared_args, $request ) {
		global $wpdb;

		if ( $request['teachers'] == '1' ) {

			$args = array(
				'per_page' => $request['page'] * $prepared_args['number'],
			);

			$user_ids = $this->get_teachers( $args );

			if ( ! empty( $user_ids ) ) {
				$prepared_args['include'] = $user_ids;
			} else {
				$prepared_args['include'] = array( 0 );
			}

			$prepared_args['orderby'] = 'include';
			$prepared_args['order']   = 'asc';

		}

		return $prepared_args;
	}

	private function get_teachers( $args ) {
		global $wpdb;

		$limit = isset( $args['per_page'] ) ? (int) $args['per_page'] : 5;

		$query  = "SELECT u.post_author as post_author, COUNT(*) as count
							  FROM " . $wpdb->prefix . "posts u
							  WHERE (post_type = 'sfwd-courses' and post_status = 'publish' )
							  AND u.post_author IN (SELECT ID FROM  {$wpdb->prefix}users WHERE ID=u.post_author)
							  GROUP BY post_author
							  ORDER BY count DESC
							  LIMIT $limit";
		$result = $wpdb->get_results( $query );

		$user_ids = array();
		if ( ! empty( $result ) ) {
			foreach ( $result as $r ) {
				$user_ids[] = $r->post_author;
			}
		}

		return $user_ids;
	}
}
