<?php

namespace BuddyBossApp\Migration\LearnDash\V1\Topic;

use BuddyBossApp\RestErrors;
use \WP_Error;
use \LearnDash_Custom_Label;


class TopicsError {
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return RestErrors
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
		}

		return self::$instance;
	}

	/**
	 * When user is not logged in this error message should be used.
	 * @return WP_Error
	 */
	public function userNotLoggedIn() {
		return RestErrors::instance()->user_not_logged_in();
	}

	/**
	 * When topic id not correct.
	 * @return WP_Error
	 */
	public function invalidTopicId() {
		return new WP_Error( 'learndash_json_topic_invalid_id', __( 'Topic not found!.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When Lesson's lesson id not correct on topic actions.
	 * @return WP_Error
	 */
	public function invalidLessonId() {
		return new WP_Error( 'learndash_json_topic_invalid_lesson', __( 'Topic\'s Lesson not found! On Which you performing action.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When Lesson's course id not correct on topic actions.
	 * @return WP_Error
	 */
	public function invalidCourseId() {
		return new WP_Error( 'learndash_json_topic_invalid_course', __( 'Topic\'s course not found! On Which you performing action.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user don't have topic access.
	 * @return WP_Error
	 */
	public function invalidTopicAccess() {
		return new WP_Error( 'learndash_json_topic_invalid_access', __( 'You do not have access of this topic.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user not completed previous Lesson/topic.
	 * @return WP_Error
	 */
	public function topicPreviousNotCompleted() {
		return new WP_Error( 'learndash_json_topic_previous_not_completed', __( "You must complete each lessons/topics in sequence.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user not completed lesson's quiz and trying to complete Lesson.
	 * @return WP_Error
	 */
	public function topicQuizNotCompleted() {
		return new WP_Error( 'learndash_json_lesson_quiz_not_completed', __( 'Topic\'s quiz not completed.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user not completed lesson's assignment and trying to complete Lesson.
	 * @return WP_Error
	 */
	public function topicAssignmentNotCompleted() {
		return new WP_Error( 'learndash_json_topic_assignment_not_completed', __( 'Please upload assignment to complete this topic.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When Lesson complete fails.
	 * @return WP_Error
	 */
	public function topicCompleteError() {
		return new WP_Error( 'learndash_json_lesson_complete_error', __( 'Something wrong with complete process!', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When assignment dir not writeable.
	 * @return WP_Error
	 */
	public function AssignmentDirNotWriteable() {
		return new WP_Error( 'learndash_json_assignment_dir_not_writeable', __( 'Unable to write to directory. Is this directory writable by the server?', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When lesson zip is not created.
	 * @return WP_Error
	 */
	public function invalidTopicZip() {
		return new WP_Error( 'learndash_json_topic_invalid_zip', __( 'Topic Zip file not created.' ), array( 'status' => 404 ) );
	}
}