<?php

namespace BuddyBossApp\Migration\LearnDash\V1\Statment;

use BuddyBossApp\Migration\LearnDash\V1\Core\LDRestController;
use BuddyBossApp\Migration\LearnDash\V1\Course\CoursesError;
use BuddyBossApp\Migration\LearnDash\V1\Lesson\LessonsError;
use BuddyBossApp\Migration\LearnDash\V1\Topic\TopicsError;
use \WP_REST_Server;
use \WP_REST_Request;
use \WP_REST_Response;

class StatmentRest extends LDRestController {

	protected static $instance;

	/**
	 * singleton instance.
	 *
	 * @since 0.1.0
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
		}

		return self::$instance;
	}

	/**
	 * Constructor.
	 *
	 * @since 0.1.0
	 */
	public function __construct() {
		$this->rest_base = 'statement';
		parent::__construct();
	}

	/**
	 * Register the component routes.
	 *
	 * @since 0.1.0
	 */
	public function register_routes() {
		register_rest_route( $this->namespace,
			'/' . $this->rest_base, array(
				array(
					'methods'  => WP_REST_Server::EDITABLE,
					'callback' => array( $this, 'upload_progress' ),
					'permission_callback' => array( $this, 'get_statement_permissions_check' ),
					'args'     => array(
						'context' => $this->get_context_param( array( 'default' => 'view' ) ),
					),
				),
			) );
	}

	/**
	 * Check if a given request has access to start quiz item.
	 *
	 * @param WP_REST_Request $request Full data about the request.
	 *
	 * @return bool|WP_Error
	 * @since 0.1.0
	 */
	public function get_statement_permissions_check( $request ) {

		$retval = true;
		if ( ! is_user_logged_in() ) {
			$retval = CoursesError::instance()->userNotLoggedIn();
		}

		/**
		 * Filter the quiz `statement` permissions check.
		 *
		 * @param bool|WP_Error   $retval  Returned value.
		 * @param WP_REST_Request $request The request sent to the API.
		 *
		 * @since 0.1.0
		 */
		return apply_filters( 'bbapp_ld_statement_permissions_check', $retval, $request );
	}

	/**
	 * Process Course Statements.
	 *
	 * @param WP_REST_Request $request Full details about the request.
	 *
	 * @return WP_REST_Response
	 * @since          0.1.0
	 * @apiPrivate
	 * @api            {POST} /wp-json/appboss/learndash/v1/statement Process Course Statements.
	 * @apiName        PostLDCourseStatements
	 * @apiGroup       Statements
	 * @apiDescription Process Course Statements.
	 * @apiVersion     1.0.0
	 * @apiPermission  LoggedInUser
	 * @apiParam {Number} id A unique numeric ID for the course.
	 * @apiParam {Array} [statements] statements data to perform action. action,object,item_id are required.  .
	 */
	public function upload_progress( $request ) {
		global $wp_rest_server;

		$request_curl = new \WP_REST_Request( 'POST', '/buddyboss-app/learndash/v1/statement' );
		$request_curl->set_body_params( $request->get_params() );
		$response = $this->dispatch( $request_curl );

		return $wp_rest_server->response_to_data( rest_ensure_response( $response ), isset( $request['_embed'] ) ? 1 : 0 );
	}
}