<?php

namespace BuddyBossApp\Migration\LearnDash\V1;

use BuddyBossApp\Migration\LearnDash\V1\Course\CoursesActionRest;
use BuddyBossApp\Migration\LearnDash\V1\Course\CoursesRest;
use BuddyBossApp\Migration\LearnDash\V1\Course\CoursesMembersRest;
use BuddyBossApp\Migration\LearnDash\V1\Course\Category\CategoriesRest;
use BuddyBossApp\Migration\LearnDash\V1\Lesson\LessonsRest;
use BuddyBossApp\Migration\LearnDash\V1\Lesson\LessonsActionRest;
use BuddyBossApp\Migration\LearnDash\V1\Topic\TopicsRest;
use BuddyBossApp\Migration\LearnDash\V1\Topic\TopicsActionRest;
use BuddyBossApp\Migration\LearnDash\V1\Quiz\QuizRest;
use BuddyBossApp\Migration\LearnDash\V1\Quiz\QuizQuestionsRest;
use BuddyBossApp\Migration\LearnDash\V1\Quiz\LeaderboardRest;
use BuddyBossApp\Migration\LearnDash\V1\Quiz\QuizUserRest;
use BuddyBossApp\Migration\LearnDash\V1\Statment\StatmentRest;
use BuddyBossApp\Migration\LearnDash\V1\Certificate\CertificateRest;
use BuddyBossApp\Migration\LearnDash\V1\User\UserRest;

if ( ! function_exists( 'add_action' ) ) {
	die( "Sorry, you can't access this directly - Security established" );
}

class RestAPI {

	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return Main
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->_load();
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function _load() {
		// Register all hooks.
		$this->hooks();
	}

	/**
	 * Register all hooks
	 * @return void
	 * @since 1.0.0
	 */
	public function hooks() {
		add_action( 'rest_api_init', array( $this, "loadRest" ) );
	}

	/**
	 *
	 */
	public function loadRest() {
		CoursesRest::instance()->register_routes();
		CoursesActionRest::instance()->register_routes();
		CoursesMembersRest::instance()->register_routes();
		CategoriesRest::instance()->register_routes();

		LessonsRest::instance()->register_routes();
		LessonsActionRest::instance()->register_routes();

		TopicsRest::instance()->register_routes();
		TopicsActionRest::instance()->register_routes();

		QuizRest::instance()->register_routes();
		QuizQuestionsRest::instance()->register_routes();
		LeaderboardRest::instance()->register_routes();
		QuizUserRest::instance()->register_routes();

		StatmentRest::instance()->register_routes();

		CertificateRest::instance()->register_routes();
		UserRest::instance();

	}
}
