<?php

namespace BuddyBossApp\Migration\LearnDash\V1\Quiz;

use BuddyBossApp\RestErrors;
use \WP_Error;
use \LearnDash_Custom_Label;


class QuizError {
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return RestErrors
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
		}

		return self::$instance;
	}

	/**
	 * When user is not logged in this error message should be used.
	 * @return WP_Error
	 */
	public function userNotLoggedIn() {
		return RestErrors::instance()->user_not_logged_in();
	}

	/**
	 * When quiz id not correct.
	 * @return WP_Error
	 */
	public function invalidQuizId() {
		return new WP_Error( 'learndash_json_quiz_invalid_id', __( 'Quiz not found!.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When user don't have quiz access.
	 * @return WP_Error
	 */
	public function invalidQuizAccess() {
		return new WP_Error( 'learndash_json_quiz_invalid_access', __( 'You do not have access of this quiz.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user not completed previous module for quiz.
	 * @return WP_Error
	 */
	public function quizPreviousModuleNotCompleted( $last_incomplete_step ) {
		if ( ! empty( $previous_item ) && $previous_item instanceof WP_Post ) {
			switch ( $previous_item->post_type ) {
				case( 'sfwd-quiz' ):
					$message = sprintf( esc_html_x( 'Please go back and complete the previous %s.', 'placeholders: quiz label', 'learndash' ), learndash_get_custom_label_lower( 'quiz' ) );
					break;
				case( 'sfwd-topic' ):
					$message = sprintf( esc_html_x( 'Please go back and complete the previous %s.', 'placeholders: topic label', 'learndash' ), learndash_get_custom_label_lower( 'topic' ) );
					break;
				default:
					$message = sprintf( esc_html_x( 'Please go back and complete the previous %s.', 'placeholders: lesson label', 'learndash' ), learndash_get_custom_label_lower( 'lesson' ) );
					break;
			}
		} else {
			$message = sprintf( esc_html_x( 'Please go back and complete the previous %s.', 'placeholders lesson', 'learndash' ), learndash_get_custom_label_lower( 'lesson' ) );
		}

		return new WP_Error( 'learndash_json_quiz_previous_module_not_completed', $message, array( 'status' => 400 ) );
	}

	/**
	 * When user not completed previous quiz.
	 * @return WP_Error
	 */
	public function quizPreviousNotCompleted() {
		return new WP_Error( 'learndash_json_quiz_previous_not_completed', __( "You have to pass the previous Module’s quiz in order to start this quizTest Quiz Pre.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user not completed previous quiz.
	 * @return WP_Error
	 */
	public function QuizAttemptsLeftEmpty() {
		return new WP_Error( 'learndash_json_quiz_attempts_Left_empty', __( "Not allow to take a Quiz.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user not completed previous quiz.
	 * @return WP_Error
	 */
	public function quizNotStarted() {
		return new WP_Error( 'learndash_json_quiz_not_started', __( "Quiz not started Please start it.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * Quiz Result data is empty when complete a quiz.
	 * @return WP_Error
	 */
	public function invalidQuizResultData() {
		return new WP_Error( 'learndash_json_quiz_result_data_invalid', __( "Quiz result data is not valid.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}



	/**
	 * When next question is not found.
	 * @return WP_Error
	 */
	public function invalidQuizNextQuestionId() {
		return new WP_Error( 'learndash_json_quiz_next_question_invalid_id', __( "Next Quiz Question not found.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When question id is incorrect.
	 * @return WP_Error
	 */
	public function invalidQuizQuestionId() {
		return new WP_Error( 'learndash_json_quiz_question_invalid_id', __( "Quiz Question not found.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When Quiz quiestion answer is empty.
	 * @return WP_Error
	 */
	public function QuizQuestionEmptyAnswer() {
		return new WP_Error( 'learndash_json_quiz_question_answer_empty', __( "Quiz question answer shouldn't empty.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When Quiz question answer check fails.
	 * @return WP_Error
	 */
	public function QuizQuestionCheckError() {
		return new WP_Error( 'learndash_json_quiz_question_check_error', __( "Something wrong with question check process!", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When Quiz quiestion answers file is empty.
	 * @return WP_Error
	 */
	public function QuizQuestionEmptyAnswersFile() {
		return new WP_Error( 'learndash_json_quiz_question_answers_file_empty', __( "Quiz question answers file shouldn't empty.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When Quiz question answer file upload fails.
	 * @return WP_Error
	 */
	public function QuizQuestionUploadError() {
		return new WP_Error( 'learndash_json_quiz_question_upload_error', __( "Something wrong with question answer file process!", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * If checkAnswers is not successfull.
	 * @return WP_Error
	 */
	public function QuizCheckQuestionAnswersError() {
		return new WP_Error( 'learndash_json_quiz_question_upload_error', __( "Something wrong with check question answer process!", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * If Leaderboard point is empty while create entry.
	 * @return WP_Error
	 */
	public function QuizLeaderboardPointEmpty() {
		return new WP_Error( 'learndash_json_leaderboard_point_empty', __( "Leaderboard Point data missing!", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * If Leaderboard result is empty while create entry.
	 * @return WP_Error
	 */
	public function QuizLeaderboardResultEmpty() {
		return new WP_Error( 'learndash_json_leaderboard_Result_empty', __( "Leaderboard result data missing!", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * If Leaderboard is not active.
	 * @return WP_Error
	 */
	public function QuizLeaderboardNotActive() {
		return new WP_Error( 'learndash_json_leaderboard_not_active', __( "Leaderboard is not activate for quiz!", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * If user don't have Leaderboard permission.
	 * @return WP_Error
	 */
	public function QuizLeaderboardPermissionInvalid() {
		return new WP_Error( 'learndash_json_leaderboard_permission_invalid', __( "Leaderboard permission is not allow!", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * If user entry already exist.
	 * @return WP_Error
	 */
	public function QuizLeaderboardEntryExist() {
		return new WP_Error( 'learndash_json_leaderboard_entry_exist', __( "Leaderboard entry already exist, You can not enter again.!", 'buddyboss-app' ), array( 'status' => 400 ) );
	}
}