<?php

namespace BuddyBossApp\Migration\LearnDash\V1\Lesson;

use BuddyBossApp\RestErrors;
use \WP_Error;
use \LearnDash_Custom_Label;


class LessonsError {
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return RestErrors
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
		}

		return self::$instance;
	}

	/**
	 * When user is not logged in this error message should be used.
	 * @return WP_Error
	 */
	public function userNotLoggedIn() {
		return RestErrors::instance()->user_not_logged_in();
	}

	/**
	 * When Lesson id not correct.
	 * @return WP_Error
	 */
	public function invalidLessonId() {
		return new WP_Error( 'learndash_json_lesson_invalid_id', __( 'Lesson not found!.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When Lesson's course id not correct on lesson actions.
	 * @return WP_Error
	 */
	public function invalidCourseId() {
		return new WP_Error( 'learndash_json_lesson_invalid_course', __( 'Lesson\'s course not found! On Which you performing action.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user don't have lesson access.
	 * @return WP_Error
	 */
	public function invalidLessonAccess() {
		return new WP_Error( 'learndash_json_lesson_invalid_access', __( 'You do not have access of this lesson.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user doesn't match required course prerequities.
	 *
	 * @param $lesson_access_from Time string to show when lesson available.
	 *
	 * @return WP_Error
	 */
	public function lessonNotAvailable( $lesson_access_from ) {
		$message = sprintf( __( 'Available on: %s', 'buddyboss-app' ), $lesson_access_from );

		return new WP_Error( 'learndash_json_lesson_not_available', $message, array( 'status' => 400 ) );
	}

	/**
	 * When user not completed previous Lesson.
	 * @return WP_Error
	 */
	public function lessonPreviousNotCompleted() {
		return new WP_Error( 'learndash_json_lesson_previous_not_completed', __( "You must complete each lessons in sequence.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user not completed lesson's topic and trying to complete lesson.
	 * @return WP_Error
	 */
	public function lessonTopicsNotCompleted() {
		return new WP_Error( 'learndash_json_lesson_topics_not_completed', __( "Lesson's topics not completed.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user not completed lesson's quiz and trying to complete Lesson.
	 * @return WP_Error
	 */
	public function lessonQuizNotCompleted() {
		return new WP_Error( 'learndash_json_lesson_quiz_not_completed', __( "Lesson's quiz not completed.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user not completed lesson's assignment and trying to complete Lesson.
	 * @return WP_Error
	 */
	public function lessonAssignmentNotCompleted() {
		return new WP_Error( 'learndash_json_lesson_assignment_not_completed', __( "Please upload assignment to complete this Lesson.", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When Lesson complete fails.
	 * @return WP_Error
	 */
	public function lessonCompleteError() {
		return new WP_Error( 'learndash_json_lesson_complete_error', __( "Something wrong with complete process!", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When assignment dir not writeable.
	 * @return WP_Error
	 */
	public function AssignmentDirNotWriteable() {
		return new WP_Error( 'learndash_json_assignment_dir_not_writeable', __( "Unable to write to directory. Is this directory writable by the server?", 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When lesson zip is not created.
	 * @return WP_Error
	 */
	public function invalidLessonZip() {
		return new WP_Error( 'learndash_json_lesson_invalid_zip', __( 'Lesson Zip file not created.' ), array( 'status' => 404 ) );
	}
}