<?php

namespace BuddyBossApp\Migration\LearnDash\V1\Course;

use BuddyBossApp\RestErrors;
use \WP_Error;
use \LearnDash_Custom_Label;

class CoursesError {
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return RestErrors
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
		}

		return self::$instance;
	}

	/**
	 * When user is not logged in this error message should be used.
	 * @return WP_Error
	 */
	public function userNotLoggedIn() {
		return RestErrors::instance()->user_not_logged_in();
	}

	/**
	 * When Course id not correct.
	 * @return WP_Error
	 */
	public function invalidCourseId() {
		return new WP_Error( 'learndash_json_course_invalid_id', __( 'Course not found!.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When user don't have course access.
	 * @return WP_Error
	 */
	public function invalidCourseAccess() {
		return new WP_Error( 'learndash_json_course_invalid_access', __( 'You do not have access to this course.', 'buddyboss-app' ), array( 'status' => 400 ) );
	}

	/**
	 * When user doesn't match required course access point.
	 *
	 * @param $course_access_points Lesson access point that required for lesson access.
	 * @param $user_course_points   USer current points.
	 *
	 * @return WP_Error
	 */
	public function invalidCourseAccessPoint( $course_access_points = 0, $user_course_points=0 ) {
		if ( ! empty( $course_access_points ) || ! empty( $user_course_points ) ){
			$message = sprintf(
				__( 'To take this %s you need at least %.01f total points. You currently have %.01f points.', 'buddyboss-app' ),
				LearnDash_Custom_Label::label_to_lower( 'course' ),
				$course_access_points,
				$user_course_points
			);

			return new WP_Error( 'learndash_json_course_points_access', $message, array( 'status' => 400 ) );
		}

		return new WP_Error( 'learndash_json_course_points_access', __( 'Course required point is not match.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When user doesn't match required course prerequities.
	 *
	 * @param $course_str Course list that required to access that lesson.
	 *
	 * @return WP_Error
	 */
	public function invalidCoursePrerequities( $course_str = '' ) {

		if ( ! empty( $course_str ) ){
			$message = sprintf(
				__( 'To take this %1$s, you need to complete the following %2$s first: %3$s', 'buddyboss-app' ),
				LearnDash_Custom_Label::label_to_lower( 'lesson' ),
				LearnDash_Custom_Label::label_to_lower( 'course' ),
				$course_str
			);

			return new WP_Error( 'learndash_json_course_prerequities', $message, array( 'status' => 400 ) );
		}

		return new WP_Error( 'learndash_json_course_prerequities', __( 'Course prerequired is not completed.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When user need to purchase course.
	 * @return WP_Error
	 */
	public function coursePurchaseRequired() {
		return new WP_Error( 'learndash_json_course_purchase_required', __( 'You need to purchase this course before start.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When Course zip is not created.
	 * @return WP_Error
	 */
	public function invalidCourseZip() {
		return new WP_Error( 'learndash_json_course_invalid_zip', __( 'Course Zip file not created.' ), array( 'status' => 404 ) );
	}

	/**
	 * When Course Statement action or object is empty.
	 * @return WP_Error
	 */
	public function invalidCourseStatement() {
		return new WP_Error( 'learndash_json_course_invalid_statement', __( 'Course statement action or object is not valid.' ), array( 'status' => 404 ) );
	}

	/**
	 * When Course Category invalid.
	 * @return WP_Error
	 */
	public function invalidCourseCatrgoryId() {
		return new WP_Error( 'learndash_json_course_Category_invalid', __( 'Course category not found!..' ), array( 'status' => 404 ) );
	}
}