<?php

namespace BuddyBossApp\Migration\LearnDash\V1\Core;

use \WP_REST_Users_Controller;
use \WP_REST_Request;
use \WP_Error;

class LDUserController extends WP_REST_Users_Controller {
	protected $namespace = "appboss/learndash/v1";
	protected $rest_base;

	/**
	 * Rest constructor.
	 */
	public function __construct() {
		parent::__construct();
		$this->namespace = "appboss/learndash/v1";
	}

	/**
	 * @return WP_Error
	 */
	public function register_routes() {
		return new WP_Error( 'invalid-method', sprintf( __( "Method '%s' not implemented. Must be overridden in subclass.", 'buddyboss-app' ), __METHOD__ ), array( 'status' => 405 ) );
	}

	/**
	 * Check if a given request has access to read /posts.
	 *
	 * @param WP_REST_Request $request Full details about the request.
	 *
	 * @return WP_Error|boolean
	 */
	public function get_items_permissions_check( $request ) {
		return parent::get_items_permissions_check( $request );
	}

	/**
	 * Check if a given request has access to read a post.
	 *
	 * @param WP_REST_Request $request Full details about the request.
	 *
	 * @return WP_Error|boolean
	 */
	public function get_item_permissions_check( $request ) {
		return parent::get_item_permissions_check( $request );
	}

	/**
	 * Get the query params for collections of endpoint.
	 *
	 * @return array
	 */
	public function get_collection_params() {

		$params = parent::get_collection_params();

		$params['context']['default'] = 'view';

		return $params;

	}

	/**
	 * Prepare links for the request.
	 *
	 * @param array item object.
	 *
	 * @return array Links for the given data.
	 */
	protected function prepare_links( $data ) {
		$links = parent::prepare_links( $data );
		return $links;
	}

	/**
	 * Dispatch the request item.
	 *
	 * @param WP_REST_Request $request Rest request.
	 *
	 * @return mixed
	 */
	public function dispatch( $request ) {

		$query_params = $request->get_params();

		if ( isset( $request->get_query_params()['_embed'] ) ) {
			$query_params['_embed'] = $request->get_query_params()['_embed'];
		}

		$request->set_query_params( $query_params );

		$server   = rest_get_server();
		$response = $server->dispatch( $request );

		return $response;
	}
}