<?php

namespace BuddyBossApp\Migration\LearnDash\V1\Core;

use \WP_REST_Controller;
use \WP_REST_Request;
use \WP_Post;
use \LearnDash_Settings_Section;

class LDRestController extends WP_REST_Controller {
	protected $namespace = "appboss/learndash/v1";
	protected $rest_base;

	/**
	 * Rest constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return WP_Error
	 */
	public function register_routes() {
		return new WP_Error( 'invalid-method', sprintf( __( "Method '%s' not implemented. Must be overridden in subclass.", 'buddyboss-app' ), __METHOD__ ), array( 'status' => 405 ) );
	}

	/**
	 * Check if a given request has access to read /posts.
	 *
	 * @param WP_REST_Request $request Full details about the request.
	 *
	 * @return WP_Error|boolean
	 */
	public function get_items_permissions_check( $request ) {
		return true;
	}

	/**
	 * Check if a given request has access to read a post.
	 *
	 * @param WP_REST_Request $request Full details about the request.
	 *
	 * @return WP_Error|boolean
	 */
	public function get_item_permissions_check( $request ) {
		return true;
	}

	/**
	 * Check if we can read a post.
	 *
	 * Correctly handles posts with the inherit status.
	 *
	 * @param object $post Post object.
	 *
	 * @return boolean Can we read it?
	 */
	public function check_read_permission( $post ) {
		return true;
	}

	/**
	 * Get the query params for collections of endpoint.
	 *
	 * @return array
	 */
	public function get_collection_params() {

		$params = parent::get_collection_params();

		$params['context']['default'] = 'view';

		return $params;

	}

	/**
	 * Prepare links for the request.
	 *
	 * @param array item object.
	 *
	 * @return array Links for the given data.
	 */
	protected function prepare_links( $data ) {
		$base = sprintf( '/%s/%s', $this->namespace, $this->rest_base );


		// Entity meta
		$links = array(
			'self'       => array(
				'href' => rest_url( trailingslashit( $base ) . $data['id'] ),
			),
			'collection' => array(
				'href' => rest_url( $base ),
			),
		);

		if ( ! empty( $data['author'] ) ) {
			$links['author'] = array(
				'href'       => rest_url( '/wp/v2/users/' . $data['author']  ),
				'embeddable' => true,
			);
		}

		return $links;
	}

	/**
	 * Dispatch the request item.
	 *
	 * @param WP_REST_Request $request Rest request.
	 *
	 * @return mixed
	 */
	public function dispatch( $request ) {

		$query_params = $request->get_params();

		if ( isset( $request->get_query_params()['_embed'] ) ) {
			$query_params['_embed'] = $request->get_query_params()['_embed'];
		}

		$request->set_query_params( $query_params );

		$server   = rest_get_server();
		$response = $server->dispatch( $request );

		return $response;
	}
}