<?php

namespace BuddyBossApp\Migration\LearnDash;

use BuddyBossApp\Migration\LearnDash\V1\RestAPI as RestAPIv1;

class Main {

	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return Main
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->hooks();
		}

		return self::$instance;
	}

	/**
	 * Register all hooks
	 * @since 1.0.0
	 * @return void
	 */
	public function hooks() {

		/**
		 * `LEARNDASH_VERSION` initialise on plugin loaded.
		 */
		add_action( 'plugins_loaded', array( $this, "_load" ) );
	}

	/**
	 *
	 */
	public function _load() {

		if ( ! defined( 'LEARNDASH_VERSION' ) || version_compare( LEARNDASH_VERSION, '3.1', '<' ) ) {
			// don't load if leanrdash is not enabled.
			return false;
		}

		RestAPIv1::instance();
		EmbedContent::instance();
	}
}
