<?php
/**
 * Holds embed content functionality.
 *
 * @package BuddyBossApp\Api\LearnDash
 */

namespace BuddyBossApp\Migration\LearnDash;

use WP_REST_Request;

/**
 * Support for embed content controller.
 */
class EmbedContent {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	protected static $instance;

	/**
	 * EmbedContent constructor.
	 */
	public function __construct() {
	}

	/**
	 * Get the instance of the class.
	 *
	 * @return mixed
	 */
	public static function instance() {

		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks();
		}

		return self::$instance;
	}

	/**
	 * Define all Hooks.
	 */
	public function hooks() {
		// Trigger the embed on low level hook. so 3rd party plugin can trigger there actions.
		// eg. contact form plugins.
		add_action( 'template_redirect', array( $this, 'init' ), 0 );
		add_action( 'template_redirect', array( $this, 'embed_video' ), 99 );
		add_action( 'template_redirect', array( $this, 'embed_content' ), 99 );
	}

	/**
	 * Init embed content on WordPress init.
	 *
	 * @return bool
	 */
	public function init() {
		if ( ! isset( $_GET['bbapp_learner_content'] ) ) { //phpcs:ignore WordPress.Security.NonceVerification.Recommended
			return false;
		}

		global $post, $wp_query;
		$wp_query->is_single = true;
		$post                = get_post( bbapp_input_clean( wp_unslash( $_GET['bbapp_learner_content'] ) ) ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.WP.GlobalVariablesOverride.Prohibited
	}

	/**
	 * Get ontent as per difeerent post type.
	 *
	 * @param string $type Post type.
	 * @param int    $item_id Post Id.
	 *
	 * @return bool
	 */
	public function get_content( $type, $item_id ) {
		$found = false;

		if ( in_array( $type, array( 'course', 'topic', 'lesson', 'quiz' ), true ) || empty( $item_id ) ) {
			if ( 'course' === $type ) {

				$course_request = new WP_REST_Request( 'GET', '/buddyboss-app/learndash/v1/courses/' . $item_id );

			} elseif ( 'topic' === $type ) {

				$course_request = new WP_REST_Request( 'GET', '/buddyboss-app/learndash/v1/topics/' . $item_id );

			} elseif ( 'lesson' === $type ) {

				$course_request = new WP_REST_Request( 'GET', '/buddyboss-app/learndash/v1/lessons/' . $item_id );

			} elseif ( 'quiz' === $type ) {

				$course_request = new WP_REST_Request( 'GET', '/buddyboss-app/learndash/v1/quiz/' . $item_id );

			}

			if ( isset( $course_request ) ) {

				$query_args = array( 'id' => $item_id );
				if ( isset( $_GET['course_id'] ) ) { //phpcs:ignore WordPress.Security.NonceVerification.Recommended
					$query_args['course_id'] = intval( $_GET['course_id'] ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended
				}
				if ( isset( $_GET['lesson_id'] ) ) { //phpcs:ignore WordPress.Security.NonceVerification.Recommended
					$query_args['lesson_id'] = intval( $_GET['lesson_id'] ); //phpcs:ignore WordPress.Security.NonceVerification.Recommended
				}

				$query_args = apply_filters( 'bbapp_learner_embed_get_content_args', $query_args, $type, $item_id );

				$course_request->set_query_params( $query_args );

				$server = rest_get_server();
				$item   = $server->dispatch( $course_request );

				if ( ! is_wp_error( $item ) ) {
					$found = true;
				}
			}
		} else {
			$item = apply_filters( 'bbapp_learner_embed_get_content', false, $type, $item_id );
			if ( ! empty( $item ) ) {
				$found = true;
			}
		}

		if ( $found ) {
			return $item->data;
		}

		return false;

	}

	/**
	 * Throw error.
	 */
	public function error() {
		?>
		<?php
	}

	/**
	 * Embed Video.
	 *
	 * @return bool
	 */
	public function embed_video() {

		if ( ! isset( $_GET['bbapp_learner_video'] ) ) { //phpcs:ignore WordPress.Security.NonceVerification.Recommended
			return false;
		}

		global $post, $temp;

		$item_id = (int) $_GET['bbapp_learner_video']; //phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$type    = isset( $_GET['type'] ) ? bbapp_input_clean( wp_unslash( $_GET['type'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

		// Globle post object updated in rest endpoint.
		$temp = $post;
		$data = $this->get_content( $type, $item_id );
		$post = $temp; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited

		$found = false;
		$video = '';

		if ( $data ) {

			$video   = $data['video'];
			$content = $data['content']['rendered'];

			// Catch the first one..
			$content = $video . $content;

			preg_match( "/vimeo.com[\/video\/](.*?)(\d+|\n)/", $content, $videos );

			if ( isset( $videos[2] ) ) {
				$found    = true;
				$video_id = $videos[2];
			}
		}

		?>
		<!DOCTYPE html>
		<html style="height:100%" lang="en">
		<head>
			<meta name="viewport" content="width=device-width, initial-scale=1.0">
		</head>
		<body>
		<style>
			body {
				padding: 0px;
				margin: 0px;
				background: black;
				color: white;
				overflow: hidden;
				height: 100%;
			}

			#query-monitor {
				display: none !important;
			}
		</style>

		<?php
		if ( ! $found ) {

			?>
			<p style="text-align:center;font-size:22px;top: 50%;position: absolute;width: 100%;height: 22px;margin-top: -12px;">
				No video found
			</p>
			<?php

		} else {
			$allow_fullscreen = apply_filters( 'bbapp_learner_embed_video_allowfullscreen', true, $post, $type );
			?>

			<iframe
					style="margin:0px;padding:0px;width:100%;height:100%;"
					src="https://player.vimeo.com/video/<?php echo bbapp_input_clean( wp_unslash( $video_id ) ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>"
					width="100%"
					height="100%"
					frameborder="0"
				<?php
				if ( $allow_fullscreen ) {
					echo 'webkitallowfullscreen
                            mozallowfullscreen
                            allowfullscreen';
				}
				?>
			>
			</iframe>

		<?php } ?>

		</body>
		</html>
		<?php
		exit;

	}


	/**
	 * Embed video content.
	 *
	 * @return bool
	 */
	public function embed_content() {

		if ( ! isset( $_GET['bbapp_learner_content'] ) ) { //phpcs:ignore WordPress.Security.NonceVerification.Recommended
			return false;
		}

		global $post, $temp, $bbapp_var;

		$item_id = ( isset( $_GET['bbapp_learner_content'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['bbapp_learner_content'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$item_id = intval( $item_id );

		$type      = ( isset( $_GET['type'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['type'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$font_size = isset( $_GET['font_size'] ) ? bbapp_input_clean( wp_unslash( $_GET['font_size'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$font_size = ( empty( $font_size ) ) ? 16 : intval( $font_size );

		// Global post object updated in rest endpoint.
		$temp = $post;
		$data = $this->get_content( $type, $item_id );
		$post = $temp; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited

		$found   = false;
		$content = '';
		if ( $data ) {
			$found   = true;
			$content = $data['content']['rendered'];
		}

		$found = true;
		?>
		<!DOCTYPE html>
		<html style="height:100%" lang="en">
		<head>
			<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"/>

			<style>
				body {
					padding: 0px;
					margin: 0px;
					color: black;
					/*overflow: hidden;*/
					height: 100%;
					-webkit-text-size-adjust: none;
					text-size-adjust: none;
					font-size: <?php echo bbapp_input_clean( wp_unslash( $font_size ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>px;
				}

				video {
					width: 100%;
					height: auto;
				}

				.wp-video {
					width: 100% !important;
				}

				@media screen and (max-width: 767px) {
					.vc_hidden-xs {
						display: none !important;
					}
				}

				/**
				 * Hide Query Monitor Related Elements.
				 */
				#query-monitor {
					display: none !important;
				}
			</style>
			<script type="text/javascript" src="<?php echo esc_url( includes_url( 'js/jquery/jquery.js' ) ); ?>"></script>
			<script>
				jQuery( document ).ready( function () {
					jQuery( 'img' ).removeAttr( 'sizes' )
					jQuery( 'img' ).removeAttr( 'srcset' )
					jQuery( 'img' ).each( function () {
						var _this = this
						bbapp_make_responsive( _this )
					} )
				} )

				jQuery( window ).resize( function () {
					jQuery( 'img' ).each( function () {
						var _this = this
						bbapp_make_responsive( _this )
					} )
				} )

				function bbapp_make_responsive( img ) {
					var img = jQuery( img )
					if( img.width() > jQuery( window ).width() ) {
						var ori_height = img.height()
						var ori_width = img.width()

						// Now make calculation based on 100% width so we can avoid margin on left because of paddings.
						img.attr( 'width', jQuery( this ).offsetParent().width() );
						height = jQuery( this ).offsetParent().width() * ori_height / ori_width;
						img.attr( 'height', height )
						// img.attr('width', jQuery(img).width());

					}
				}
			</script>
			<?php
			/**
			 * Triggered  on embed content head.
			 *
			 * @param int|string $item_id Content.
			 * @param string     $item_id Content type.
			 */
			do_action( 'bbapp_learner_embed_content_head', $item_id, $type );
			?>
			<script>
				//fitvid 1.1
				!function ( t ) {
					"use strict";
					t.fn.fitVids = function ( e ) {
						var i = { customSelector: null, ignore: null };
						if( !document.getElementById( "fit-vids-style" ) ) {
							var r = document.head || document.getElementsByTagName( "head" )[0],
								a = document.createElement( "div" );
							a.innerHTML = '<p>x</p><style id="fit-vids-style">.fluid-width-video-wrapper{width:100%;position:relative;padding:0;}.fluid-width-video-wrapper iframe,.fluid-width-video-wrapper object,.fluid-width-video-wrapper embed {position:absolute;top:0;left:0;width:100%;height:100%;}</style>', r.appendChild( a.childNodes[1] )
						}
						return e && t.extend( i, e ), this.each( function () {
							var e = ['iframe[src*="player.vimeo.com"]', 'iframe[src*="youtube.com"]', 'iframe[src*="youtube-nocookie.com"]', 'iframe[src*="kickstarter.com"][src*="video.html"]', "object", "embed"];
							i.customSelector && e.push( i.customSelector );
							var r = ".fitvidsignore";
							i.ignore && (r = r + ", " + i.ignore);
							var a = t( this ).find( e.join( "," ) );
							(a = (a = a.not( "object object" )).not( r )).each( function () {
								var e = t( this );
								if( !(e.parents( r ).length > 0 || "embed" === this.tagName.toLowerCase() && e.parent( "object" ).length || e.parent( ".fluid-width-video-wrapper" ).length) ) {
									e.css( "height" ) || e.css( "width" ) || !isNaN( e.attr( "height" ) ) && !isNaN( e.attr( "width" ) ) || (e.attr( "height", 9 ), e.attr( "width", 16 ));
									var i = ("object" === this.tagName.toLowerCase() || e.attr( "height" ) && !isNaN( parseInt( e.attr( "height" ), 10 ) ) ? parseInt( e.attr( "height" ), 10 ) : e.height()) / (isNaN( parseInt( e.attr( "width" ), 10 ) ) ? e.width() : parseInt( e.attr( "width" ), 10 ));
									if( !e.attr( "name" ) ) {
										var a = "fitvid" + t.fn.fitVids._count;
										e.attr( "name", a ), t.fn.fitVids._count++
									}
									e.wrap( '<div class="fluid-width-video-wrapper"></div>' ).parent( ".fluid-width-video-wrapper" ).css( "padding-top", 100 * i + "%" ), e.removeAttr( "height" ).removeAttr( "width" )
								}
							} )
						} )
					}, t.fn.fitVids._count = 0
				}( window.jQuery || window.Zepto );

				jQuery( document ).ready( function () {
					jQuery( "#bbapp_learner_content" ).fitVids();
				} );
			</script>
		</head>
		<body id="bbapp_learner_content">
		<?php
		if ( $found ) {
			echo $content; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}
		?>
		</body>
		</html>
		<?php
		exit;
	}
}
