<?php

namespace BuddyBossApp\Migration;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}


use WP_Error;
use WP_REST_Server;

class MetaApi {

	public $namespace   = 'appboss/v1';
	private $route_slug = '/meta';
	private static $instance;

	private function __construct() {
		// ... leave empty, see Singleton below
	}

	/**
	 * Get the instance of this class.
	 *
	 * @return MetaApi
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
			self::$instance->init();
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function init() {
		add_action( 'rest_api_init', array( $this, 'register_routes' ) );

	}

	/**
	 *
	 */
	public function register_routes() {
		// Item Meta Last changed.
		register_rest_route(
			$this->namespace,
			$this->route_slug . '/last-changed/' . '(?P<item_type>\S+)/',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this, 'rest_item_last_changed' ),
					'permission_callback' => '__return_true',
					'args'                => array(
						'item_type' => array(
							'required'    => true,
							'type'        => 'string',
							'description' => __( 'Content Type.', 'buddyboss-app' ),
							'enum'        => array( 'course', 'lesson', 'topic' ),
						),
						'item_id'   => array(
							'required'    => true,
							'type'        => 'string',
							'description' => __( 'Item Id', 'buddyboss-app' ),
						),
						'timestamp' => array(
							'required'    => true,
							'type'        => 'string',
							'description' => __( 'Timestamp', 'buddyboss-app' ),
						),

					),
				),
			)
		);

		// Item Meta Since.
		register_rest_route(
			$this->namespace,
			$this->route_slug . '/(?P<item_type>\S+)',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this, 'rest_items_meta_since' ),
					'permission_callback' => '__return_true',
					'args'                => array(
						'item_type'   => array(
							'required'    => true,
							'type'        => 'string',
							'description' => __( 'Content Type.', 'buddyboss-app' ),
							'enum'        => array( 'course', 'lesson', 'topic' ),
						),
						'item_filter' => array(
							'required'    => true,
							'type'        => 'array',
							'description' => __( 'Item Id, timestamp', 'buddyboss-app' ),
						),
					),
				),
			)
		);

	}

	/**
	 * @param $request
	 * @return WP_Error
     * @apiPrivate
	 * @api {GET} /wp-json/appboss/v1/meta/:item_type Item(s) meta since
	 * @apiName GetItemMetaSince
	 * @apiGroup Meta
	 * @apiVersion 1.0.0
	 * @apiPermission LoggedInUser
	 * @apiDescription Information such as Last changed, changed by and further
	 * @apiUse apidocForItemsMetaSinceV1
	 */
	public function rest_items_meta_since( $request ) {
		$item_type = $request->get_param( 'item_type' );
		global $wp_rest_server;

		$request_curl = new \WP_REST_Request( 'GET', "/buddyboss-app/v1/meta/{$item_type}" );
		$request_curl->set_query_params( $request->get_params() );
		$response = $this->dispatch( $request_curl );

		return $wp_rest_server->response_to_data( rest_ensure_response( $response ), isset( $request['_embed'] ) ? 1 : 0 );

	}


	/**
	 * @param $request
	 * @return WP_Error
     * @apiPrivate
	 * @api {GET} /wp-json/appboss/v1/meta/last-changed/:item_type Item last changed
	 * @apiName GetItemMetaLastChanged
	 * @apiGroup Meta
	 * @apiVersion 1.0.0
	 * @apiPermission LoggedInUser
	 * @apiDescription Last change information for self and children's
	 * @apiUse apidocForItemMetaLastChangedV1
	 */
	public function rest_item_last_changed( $request ) {
		$item_type = $request->get_param( 'item_type' );
		global $wp_rest_server;

		$request_curl = new \WP_REST_Request( 'GET', "/buddyboss-app/v1/meta/last-changed/{$item_type}" );
		$request_curl->set_query_params( $request->get_params() );
		$response = $this->dispatch( $request_curl );

		return $wp_rest_server->response_to_data( rest_ensure_response( $response ), isset( $request['_embed'] ) ? 1 : 0 );
	}

	/**
	 * Dispatch the request item.
	 *
	 * @param $request
	 *
	 * @return mixed
	 */
	protected function dispatch( $request ) {

		$query_params = $request->get_params();

		if ( isset( $request->get_query_params()["_embed"] ) ) {
			$query_params["_embed"] = $request->get_query_params()["_embed"];
		}

		$request->set_query_params( $query_params );

		$server   = rest_get_server();
		$response = $server->dispatch( $request );

		return $response;
	}

}
