<?php

namespace BuddyBossApp\Migration\Integrations\Vimeo;

use BuddyBossApp\AppSettings;
use BuddyBossApp\ManageApp;
use BuddyBossApp\RestErrors;
use WP_Error;
use WP_REST_Server;

class RestAPI extends \WP_REST_Controller {

	protected $namespace = 'appboss/core/v1';
	private static $instance;

	/**
	 * RestAPI constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 * Load hooks function on instance.
	 */
	public function load() {
		/** Nothing here */
		$this->hooks();
	}

	/**
	 * Adding hooks.
	 */
	public function hooks() {
		add_action( 'rest_api_init', array( $this, 'register_routes' ), 99 );
	}

	/**
	 * Register routes.
	 */
	public function register_routes() {

		register_rest_route(
			$this->namespace,
			'/vimeo-fetch/video/(?P<video_id>\d+)',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this, 'get_item' ),
					'permission_callback' => array( $this, 'get_item_permissions_check' ),
					'args'                => array(
						'context' => $this->get_context_param( array( 'default' => 'view' ) ),
					),
				),
				'schema' => array( $this, 'get_public_item_schema' ),
			)
		);
	}

	/**
	 * Check if a given request has access to read a post.
	 *
	 * @param WP_REST_Request $request Full details about the request.
	 *
	 * @return WP_Error|boolean
	 */
	public function get_item_permissions_check( $request ) {
		return apply_filters( 'ap_rest_vimeo_video_item_permission', true );
	}

	/**
	 * Get video information from vimeo.
	 * This will only return the video information of video hosted on the account of auth code owner.
	 *
	 * @param \WP_REST_Request $request
	 *
	 * @return \WP_Error|\WP_HTTP_Response|\WP_REST_Response
	 */
	public function get_item( $request ) {

		$video_id = $request->get_param( 'video_id' );

		global $wp_rest_server;

		$request_curl = new \WP_REST_Request( 'GET', "/buddyboss-app/core/v1/vimeo-fetch/video/{$video_id}" );
		$request_curl->set_query_params( $request->get_params() );
		$response = $this->dispatch( $request_curl );

		return $wp_rest_server->response_to_data( rest_ensure_response( $response ), isset( $request['_embed'] ) ? 1 : 0 );
	}

	/**
	 * Dispatch the request item.
	 *
	 * @param $request
	 *
	 * @return mixed
	 */
	protected function dispatch( $request ) {

		$query_params = $request->get_params();

		if ( isset( $request->get_query_params()["_embed"] ) ) {
			$query_params["_embed"] = $request->get_query_params()["_embed"];
		}

		$request->set_query_params( $query_params );

		$server   = rest_get_server();
		$response = $server->dispatch( $request );

		return $response;
	}

}
