<?php

namespace BuddyBossApp\Migration\Integrations\H5P;

use H5P_Plugin_Admin;
use H5PContentQuery;
use WP_REST_Controller;
use WP_REST_Server;

class RestAPI extends WP_REST_Controller {

	protected $namespace = 'appboss/h5p/v1';
	protected $rest_base = 'items';
	protected static $instance;

	/**
	 * RestAPI constructor.
	 */
	public function __construct() {
		/** Nothing here */
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 * Load hooks.
	 */
	public function hooks() {
		add_action( 'init', array( $this, 'init' ) );
	}

	/**
	 * Init method.
	 */
	public function init() {
		if ( class_exists( 'H5P_Plugin' ) ) {
			add_action( 'rest_api_init', array( $this, 'register_routes' ), 99 );
		}
	}

	/**
	 * Register routes.
	 */
	public function register_routes() {
		if ( class_exists( 'H5P_Plugin' ) ) {
			register_rest_route(
				$this->namespace,
				$this->rest_base,
				array(
					array(
						'methods'             => WP_REST_Server::READABLE,
						'callback'            => array( $this, 'get_items' ),
						'args'                => array(),
						'permission_callback' => array( $this, 'rest_api_permission' ),
					),
				)
			);
		}
	}

	/**
	 * Api permission.
	 *
	 * @param $request
	 *
	 * @return mixed|void
	 */
	public function rest_api_permission( $request ) {
		$retval = true;

		/**
		 * Filter the course H5P list `get_items` permissions check.
		 *
		 * @since 0.1.0
		 */
		return apply_filters( 'bbapp_h5p_content_list_permissions_check', $retval, $request );
	}

	/**
	 * Get H5P items list for H5P block select option.
	 *
	 * @param $request
	 *
	 * @return array|\WP_Error|\WP_HTTP_Response|\WP_REST_Response
	 */
	public function get_items( $request ) {
		global $wp_rest_server;

		$request_curl = new \WP_REST_Request( 'GET', '/buddyboss-app/h5p/v1/items' );
		$request_curl->set_query_params( $request->get_params() );
		$response = $this->dispatch( $request_curl );

		return $wp_rest_server->response_to_data( rest_ensure_response( $response ), isset( $request['_embed'] ) ? 1 : 0 );
	}

	/**
	 * Dispatch the request item.
	 *
	 * @param $request
	 *
	 * @return mixed
	 */
	protected function dispatch( $request ) {

		$query_params = $request->get_params();

		if ( isset( $request->get_query_params()["_embed"] ) ) {
			$query_params["_embed"] = $request->get_query_params()["_embed"];
		}

		$request->set_query_params( $query_params );

		$server   = rest_get_server();
		$response = $server->dispatch( $request );

		return $response;
	}

}
