<?php
namespace BuddyBossApp\Migration\Integrations\BuddyBossMedia;

use \WP_Error as WP_Error;

class RestAPI extends \WP_REST_Controller {

	protected $namespace = 'appboss/bb-media/v1';
	protected static $instance;

	/**
	 * RestAPI constructor.
	 */
	public function __construct() {
		/** Nothing here */
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks(); // run the hooks.
		}
		return self::$instance;
	}

	/**
	 *
	 */
	public function hooks() {
		add_action( 'rest_api_init', array( $this, 'registerRoutes' ), 99 );
	}

	/**
	 *
	 */
	public function registerRoutes() {

		register_rest_route(
			$this->namespace,
			'/media',
			array(
				array(
					'methods'             => \WP_REST_Server::CREATABLE,
					'callback'            => array( $this, 'media_create' ),
					'permission_callback' => '__return_true',
					'args'                => $this->get_media_args(),
				),
			)
		);

	}

	/**
	 * Return args data for media create endpoint
	 * helps for easily fiilter request data and validation
	 *
	 * @return array
	 */
	public function get_media_args() {
		$args = array();
		return $args;
	}

	/**
     * @apiPrivate
	 * @api {POST} /wp-json/appboss/bb-media/v1/media Create media
	 * @apiName CreateBuddyBossMedia
	 * @apiGroup BuddyBossMedia
	 * @apiVersion 1.0.0
	 * @apiPermission LoggedInUser
	 * @apiDescription Create(upload) the media file of/for bb-media component
	 */
	public function media_create( $request ) {
		global $wp_rest_server;

		$request_curl = new \WP_REST_Request( 'POST', '/buddyboss-app/bb-media/v1/media' );
		$request_curl->set_body_params( $request->get_params() );
		$request_curl->set_file_params( $request->get_file_params() );
		$response = $this->dispatch( $request_curl );

		return $wp_rest_server->response_to_data( rest_ensure_response( $response ), isset( $request['_embed'] ) ? 1 : 0 );

	}

	/**
	 * Dispatch the request item.
	 *
	 * @param $request
	 *
	 * @return mixed
	 */
	protected function dispatch( $request ) {

		$query_params = $request->get_params();

		if ( isset( $request->get_query_params()["_embed"] ) ) {
			$query_params["_embed"] = $request->get_query_params()["_embed"];
		}

		$request->set_query_params( $query_params );

		$server   = rest_get_server();
		$response = $server->dispatch( $request );

		return $response;
	}
}
