<?php
namespace BuddyBossApp\Migration\Integrations\BuddyBossMedia;

use BuddyBossApp\Migration\Integrations\BuddyBossMedia\RestAPI;

// Contains all BuddyBoss Media API related feature.
class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
		// Using Singleton, see instance()
	}

	/**
	 * @return Main
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load(); // run the hooks.
		}
		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {

		// If buddyboss media plugin exits then execute the code.
		if ( ( function_exists( 'buddyboss_media_init' ) ) ) {
			RestAPI::instance();
		}
	}

}
