<?php
namespace BuddyBossApp\Migration\Integrations\BbPress;
// @FYI - old file name was : class.bbapp_bbpress_rest_api
// v1 Standard, Contain functionality for required additional rest api endpoints for bbpress.
class RestAPI extends \WP_REST_Controller {

	private static $instance;
	protected $namespace_slug = '';
	protected $namespace = '/bbpress/v1';

	/**
	 * RestAPI constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if (!isset(self::$instance)) {
			$class = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		/** Nothing here */
		$this->namespace_slug = "appboss";
		$this->namespace = $this->namespace_slug . $this->namespace;
		$this->hooks();
	}

	/**
	 *
	 */
	public function hooks() {
		add_action('rest_api_init', array($this, "registerRoutes"), 99);
	}

	/**
	 *
	 */
	public function registerRoutes() {

		/**
		 * Deprecated Support for Push Notification on bbPress Endpoint.
		 * Latest App Source Uses /wp-json/appboss/core/v1/...
		 */

		if (class_exists("\bbapp_notification_rest_api")) {

			register_rest_route($this->namespace, '/notification', array(
				array(
					'methods' => \WP_REST_Server::READABLE,
					'callback' => array(\bbapp_notification_rest_api::instance(), 'get_notifications'),
					'permission_callback' => '__return_true',
					'args' => array(),
				),
			));

		}
	}

}
