<?php

namespace BuddyBossApp\Migration\Integrations\BadgeOs;

use BuddyBossApp\App\App;

class RestAPI {


	protected static $instance;

	/**
	 * RestAPI constructor.
	 */
	public function __construct() {
		 /** Nothing here */
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks(); // run the hooks.
		}
		return self::$instance;
	}

	/**
	 *
	 */
	public function hooks() {
		add_action( 'init', array( $this, 'init' ) );
	}

	/**
	 *
	 */
	public function init() {
		if ( class_exists( 'BadgeOS' ) ) {
			RestAPIPoint::instance();
			RestAPIAchievement::instance();
			RestAPIRank::instance();
		}
	}

}
