<?php
/**
 * Note: This is temp migration file. on the final merge of this repo on master this should be moved into dadicated migration plugin.
 */

namespace BuddyBossApp\Migration;

use BuddyBossApp\Helpers\BBAPP_File;
use BuddyBossApp\Helpers\File;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'IconPicker' ) ) {
	class IconPicker {

		private static $instance;

		/**
		 * Get the instance of the class.
		 *
		 * @return IconPicker
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) ) {
				$class          = __CLASS__;
				self::$instance = new $class;
				self::$instance->_load();
			}

			return self::$instance;
		}

		/**
		 * Migrate constructor.
		 */
		public function __construct() {
		}

		/**
		 * Migrate load method.
		 */
		public function _load() {
			// this hook should load first.
			$this->rename_upload_folder();
			add_action( 'plugins_loaded', array( $this, 'migrate_load' ) );
		}

		/**
		 * Migrate the options name.
		 */
		public function migrate_load() {
			$this->migrate_tabbar_icon_data();
			$this->migrate_new_tabbar_icon_data();
		}

		/**
		 * Migrate old custom icons to new folder location.
		 */
		public function rename_upload_folder() {
			$upload_dir = wp_upload_dir();
			$dir_old    = $upload_dir["basedir"] . "/bbapp-custom-icon";
			$dir_new    = $upload_dir["basedir"] . "/bbapp/custom-icons";

			if ( bbapp_get_network_option( "bbapp_migrate_custom_icons_path" ) != "1" ) {

				if ( file_exists( $dir_old ) ) {
					BBAPP_File::create_dir($dir_new);
					BBAPP_File::copy_dir( $dir_old, $dir_new );
				}

				bbapp_set_network_option( "bbapp_migrate_custom_icons_path", "1" );
			}
		}

		/**
		 * No not modify nature of below code. as they won't be executed on already run sites.
		 * If you want to modify write a new function.
		 */
		public function migrate_tabbar_icon_data() {
			$bbapp_migration = get_option( 'bbapp_migrate_tabbar_icon_uri' );
			if ( "1" !== $bbapp_migration ) {

				$app_settings = \BuddyBossApp\ManageApp::instance()->get_app_settings();
				if ( isset( $app_settings['menu'] ) ) {
					foreach ( $app_settings['menu'] as $key => $menus ) {

						if ( 'more' === $key || 'tabbar' == $key ) {
							foreach ( $menus as $m_key => $menu ) {
								if ( isset( $menu['type'] ) ) {
									if ( 'section' === $menu['type'] ) {
										if ( ! empty( $menu['section'] ) ) {
											foreach ( $menu['section'] as $section_key => $section ) {
												if ( isset( $section['icon'] ) && isset( $section['icon']['uri'] ) ) {
													$app_settings['menu'][ $key ][ $m_key ]['section'][ $section_key ]['icon']['uri'] = str_replace( "appboss/", "bbapp/", $section['icon']['uri'] );
												}
											}
										}
									} else {
										if ( isset( $menu['icon'] ) && isset( $menu['icon']['uri'] ) ) {
											$app_settings['menu'][ $key ][ $m_key ]['icon']['uri'] = str_replace( "appboss/", "bbapp/", $menu['icon']['uri'] );
										}
									}
								}
							}
						}
					}
				}

				\BuddyBossApp\ManageApp::instance()->update_app_settings( $app_settings );
				update_option( 'bbapp_migrate_tabbar_icon_uri', "1" );
			}
		}

		public function migrate_new_tabbar_icon_data() {
			$bbapp_migration = get_option( 'bbapp_migrate_new_tabbar_icon_uri' );
			if ( "1" !== $bbapp_migration ) {
				$app_settings = get_option('bbapp_menus');
				if ( isset( $app_settings ) && ! empty( $app_settings ) ) {
					foreach ( $app_settings as $key => $menus ) {

						if ( 'more' === $key || 'tabbar' == $key ) {
							foreach ( $menus as $m_key => $menu ) {
								if ( isset( $menu['type'] ) ) {
									if ( 'section' === $menu['type'] ) {
										if ( ! empty( $menu['section'] ) ) {
											foreach ( $menu['section'] as $section_key => $section ) {
												if ( isset( $section['icon'] ) && isset( $section['icon']['uri'] ) ) {
													$app_settings[ $key ][ $m_key ]['section'][ $section_key ]['icon']['uri'] = str_replace( "appboss/", "bbapp/", $section['icon']['uri'] );
												}
											}
										}
									} else {
										if ( isset( $menu['icon'] ) && isset( $menu['icon']['uri'] ) ) {
											$app_settings[ $key ][ $m_key ]['icon']['uri'] = str_replace( "appboss/", "bbapp/", $menu['icon']['uri'] );
										}
									}
								}
							}
						}
					}
					update_option( 'bbapp_menus',$app_settings );
				}
				update_option( 'bbapp_migrate_new_tabbar_icon_uri', "1" );
			}
		}


	}
}