<?php
/**
 * Note: This is temp migration file. on the final merge of this repo on master this should be moved into dadicated migration plugin.
 */

namespace BuddyBossApp\Migration;

use BuddyBossApp\Helpers\BBAPP_File;
use BuddyBossApp\Helpers\File;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'IAP' ) ) {
	class IAP {

		private static $instance;

		/**
		 * Get the instance of the class.
		 *
		 * @return IAP
		 */
		public static function instance() {
			if ( ! isset( self::$instance ) ) {
				$class          = __CLASS__;
				self::$instance = new $class;
				self::$instance->_load();
			}

			return self::$instance;
		}

		/**
		 * Migrate constructor.
		 */
		public function __construct() {
		}

		/**
		 * Migrate load method.
		 */
		public function _load() {
			// this hook should load first.
			$this->rename_upload_folder();
			add_action( 'plugins_loaded', array( $this, 'migrate_load' ), 10 );
		}

		/**
		 * Migrate the options name.
		 */
		public function migrate_load() {
			$this->migrate_iap_settings_data();
		}

		/**
		 * Migrate old typography fonts to new folder location.
		 */
		public function rename_upload_folder() {
			$upload_dir = wp_upload_dir();
			$dir_old    = $upload_dir["basedir"] . "/ab-iap";
			$dir_new    = $upload_dir["basedir"] . "/bbapp/iap";

			if ( bbapp_get_network_option( "bbapp_migrate_iap_path" ) != "1" ) {

				if ( file_exists( $dir_old ) ) {
					BBAPP_File::create_dir($dir_new);
					BBAPP_File::copy_dir( $dir_old, $dir_new );
				}

				bbapp_set_network_option( "bbapp_migrate_iap_path", "1" );
			}
		}

		/**
		 * iap setting data.
		 */
		public function migrate_iap_settings_data() {
			$bbapp_migration = get_option( 'bbapp_migrate_iap_settings_data' );
			if ( "1" !== $bbapp_migration ) {
				$migraton_keys = array(
					'bbapp_iap'      => array(
						'setting_apple_iap_secret_key'     => 'publish.ios.private_key',
						'setting_apple_iap_issuer_id'      => 'publish.ios.issuer_id',
						'setting_apple_iap_key_identifier' => 'publish.ios.key_id',
						'setting_apple_iap_secret'         => 'publish.ios.shared_secret',
						'google_service_account_json'      => 'publish.android.account_key',
					),
					'bbapp_settings' => array(
						'ios.store_app_id'       => 'publish.ios.store_app_id',
						'android.application_id' => 'publish.android.namespace',
					)
				);
				$app_settings  = \BuddyBossApp\ManageApp::instance()->get_app_settings();
				if ( ! empty( $app_settings ) ) {
					foreach ( $migraton_keys as $option_key => $migraton_key ) {
						$option_data = get_option( $option_key );
						foreach ( $migraton_key as $old_key => $new_key ) {
							if ( isset( $option_data[ $old_key ] ) ) {
								$app_settings[ $new_key ] = str_replace( "/ab-iap/", "/bbapp/iap/", $option_data[ $old_key ] );
							}
						}
					}
					\BuddyBossApp\ManageApp::instance()->update_app_settings( $app_settings );
				}
				update_option( 'bbapp_migrate_iap_settings_data', "1" );
			}
		}
	}
}