<?php
if (!defined('ABSPATH')) {
    exit();
}

if (!function_exists("bbapp_learners_download_html")) {
    function bbapp_learners_download_html($folder_path, $content)
    {
        $content = str_replace('&#8221;', '"', $content);
        $content = html_entity_decode($content);

        /**
         * https://regex101.com/r/F42TTK/1
         */
        $pattern = "/src=['\"]((.+)?(?:.+))['\"]/iU";
        preg_match_all($pattern, $content, $images);
        preg_replace_callback($pattern, function ($match) use ($folder_path, &$content) {
            $assets_name = uniqid() . basename($match[1]);

            $data = \BuddyBossApp\Helpers\BBAPP_File::read_file($match[1]);
            bbapp_learners_write_file($folder_path . $assets_name, $data);

            $content = str_replace($match[1], './' . urlencode($assets_name), $content);

        }, $content);

        return $content;
    }
}

if (!function_exists("bbapp_learners_setpath")) {
    function bbapp_learners_setpath($dir)
    {
        $upload_dir = wp_upload_dir();
        if (!empty($upload_dir['basedir'])) {
            $bbapp_learners_dirname = trailingslashit($upload_dir['basedir']) . trailingslashit('bbapp-learners') . $dir;
            if (!file_exists($bbapp_learners_dirname)) {
                wp_mkdir_p($bbapp_learners_dirname);
            }
        }
        return $bbapp_learners_dirname;
    }
}

if (!function_exists("bbapp_learners_getpath")) {
    function bbapp_learners_getpath($dir)
    {
        $upload_dir = wp_upload_dir();
        if (!empty($upload_dir['basedir'])) {
            $bbapp_learners_dirname = trailingslashit($upload_dir['basedir']) . trailingslashit('bbapp-learners') . $dir;
        }
        return $bbapp_learners_dirname;
    }
}

if (!function_exists("bbapp_learners_delete_directory")) {
    function bbapp_learners_delete_directory($dirname)
    {
        if (is_dir($dirname) && file_exists($dirname)) {
            $dir_handle = opendir($dirname);
        }
        if (!isset($dir_handle) || empty($dir_handle)) {
            return false;
        }
        while ($file = readdir($dir_handle)) {
            if ($file != "." && $file != "..") {
                if (!is_dir($dirname . "/" . $file)) {
                    unlink($dirname . "/" . $file);
                } else {
                    bbapp_learners_delete_directory($dirname . '/' . $file);
                }
            }
        }
        closedir($dir_handle);
        rmdir($dirname);
        return true;
    }
}

if (!function_exists("bbapp_learners_geturl")) {
    function bbapp_learners_geturl($dir)
    {
        $upload_dir = wp_upload_dir();
        if (!empty($upload_dir['baseurl'])) {
            $bbapp_learners_dirname = trailingslashit($upload_dir['baseurl']) . trailingslashit('bbapp-learners') . $dir;
        }
        return $bbapp_learners_dirname;
    }
}

if (!function_exists("bbapp_learners_write_file")) {
    function bbapp_learners_write_file($file, $content)
    {
        \BuddyBossApp\Helpers\BBAPP_File::write_file($file, $content);
    }
}

if (!function_exists("bbapp_learners_zip_create")) {
    function bbapp_learners_zip_create($folder_path, $zip_name)
    {

        $rootPath = realpath($folder_path);

        $zip_name = $zip_name . '.zip';
        $zip_path = bbapp_learners_setpath('');
        $zip_path = $zip_path . $zip_name;

        $zip = new \ZipArchive();
        $zip->open($zip_path, ZipArchive::CREATE | ZipArchive::OVERWRITE);

        // Create recursive directory iterator
        /** @var SplFileInfo[] $files */
        $files = new \RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($rootPath),
            RecursiveIteratorIterator::LEAVES_ONLY
        );

        foreach ($files as $name => $file) {
            // Skip directories (they would be added automatically)
            if (!$file->isDir()) {
                // Get real and relative path for current file
                $filePath = $file->getRealPath();
                $relativePath = substr($filePath, strlen($rootPath) + 1);

                // Add current file to archive
                $zip->addFile($filePath, $relativePath);
            }
        }
        // Zip archive will be created only after closing object
        $zip->close();

        if (file_exists($zip_path)) {
            return bbapp_learners_geturl($zip_name);
        }
        return false;
    }
}

if (!function_exists("bbapp_learners_fix_relative_urls_protocol")) {

    /**
     * Fix the relative content urls protocol.
     * eg. changes //example.com to https://example.com
     * @param $content
     *
     * @return mixed
     */
    function bbapp_learners_fix_relative_urls_protocol($content)
    {
        $content = preg_replace('/(src|href)=["|\']\/\/(.*?)["|\']/', '$1="https://$2"', $content);
        return $content;
    }

}