<?php
namespace BuddyBossApp\Api\Learner;
// NOTE : Old classname was class.bbapp_learner_user_rest. By Ketan, Oct-2019
// (v1 Standard) Contain functionality for required additional rest api endpoints for learndash.
class UserRest {

	protected static $instance;

	/**
	 * UserRest constructor.
	 */
	public function __construct() {
		add_action('rest_api_init', array($this, "register_learner_fields"), 99);
		add_filter('rest_user_query', array($this, 'filter_teachers'), 10, 2);
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if (!isset(self::$instance)) {
			$class = __CLASS__;
			self::$instance = new $class;
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function register_learner_fields() {
		register_rest_field('user',
			'points',
			array(
				'get_callback' => array($this, "get_points"),
				'update_callback' => null,
				'schema' => null,
			)
		);

		register_rest_field('user',
			'user_points',
			array(
				'get_callback' => array($this, "get_user_points"),
				'update_callback' => null,
				'schema' => null,
			)
		);
	}

	/**
	 * @param $object
	 * @param $field_name
	 * @param $request
	 *
	 * @return int
	 */
	public function get_points($object, $field_name, $request) {
		return (int) apply_filters("bbapp_learner_get_points", 0, (int) $object["id"]);
	}

	/**
	 * @param $object
	 * @param $field_name
	 * @param $request
	 *
	 * @return mixed
	 */
	public function get_user_points($object, $field_name, $request) {
		return apply_filters("bbapp_learner_get_user_points", array(
			array(
				'point' => 0,
				'label' => 'Points',
			),
		), (int) $object["id"]);
	}

	/**
	 * @param $prepared_args
	 * @param $request
	 *
	 * @return mixed
	 */
	public function filter_teachers($prepared_args, $request) {
		global $wpdb;

		if ($request['teachers'] == '1') {

			$query_args = array(
				'posts_per_page' => $request['page'] * $prepared_args['number'],
			);

			$user_ids = apply_filters("bbapp_learner_get_course_teachers", array(), $query_args, $request);

			if (!empty($user_ids)) {
				$prepared_args['include'] = $user_ids;
			} else {
				$prepared_args['include'] = array(0);
			}

			$prepared_args['orderby'] = 'include';
			$prepared_args['order'] = 'asc';

		}

		return $prepared_args;
	}
}
