<?php
namespace BuddyBossApp\Api\Learner;
use WP_Error;
use WP_REST_Controller;
use WP_REST_Request;

// NOTE : Old classname was class.bbapp_learner_terms_rest. By Ketan, Oct-2019
// Api structure class for course
class TermsRest extends WP_REST_Controller {

	protected $namespace = "appboss/learner/v1";
	protected $rest_base;

	/**
	 * TermsRest constructor.
	 */
	public function __construct() {
		add_action('rest_api_init', array($this, "registerRoutes"), 99);
	}

	/**
	 * @return WP_Error
	 */
	public function registerRoutes() {
		// @todo : @ayush or @dipesh, do we need to register this here?! By Ketan, 2019
		return new WP_Error('invalid-method', sprintf(__("Method '%s' not implemented. Must be overridden in subclass."), __METHOD__), array('status' => 405));
	}

	/**
	 * Check if a given request has access to read /posts.
	 *
	 * @param  WP_REST_Request $request Full details about the request.
	 * @return WP_Error|boolean
	 */
	public function get_items_permissions_check($request) {
		return apply_filters('bbapp_learner_get_' . $this->rest_base . '_items_permissions', false, $request);
	}

	/**
	 * Check if a given request has access to read a post.
	 *
	 * @param  WP_REST_Request $request Full details about the request.
	 * @return WP_Error|boolean
	 */
	public function get_item_permissions_check($request) {
		return apply_filters('bbapp_learner_get_' . $this->rest_base . '_item_permissions', false, $request);
	}

	/**
	 * Check if we can read a post.
	 *
	 * Correctly handles posts with the inherit status.
	 *
	 * @return boolean Can we read it?
	 */
	public function check_is_taxonomy_allowed() {
		return apply_filters('bbapp_learner_get_' . $this->rest_base . '_taxonomy_allowed', false);
	}

	/**
	 * Retrieves the query params for collections.
	 *
	 * @since 4.7.0
	 *
	 * @return array Collection parameters.
	 */
	public function get_collection_params() {
		$query_params = parent::get_collection_params();

		$query_params['context']['default'] = 'view';

		$query_params['exclude'] = array(
			'description' => __('Ensure result set excludes specific IDs.'),
			'type' => 'array',
			'items' => array(
				'type' => 'integer',
			),
			'default' => array(),
		);

		$query_params['include'] = array(
			'description' => __('Limit result set to specific IDs.'),
			'type' => 'array',
			'items' => array(
				'type' => 'integer',
			),
			'default' => array(),
		);

		$query_params['offset'] = array(
			'description' => __('Offset the result set by a specific number of items.'),
			'type' => 'integer',
		);

		$query_params['order'] = array(
			'description' => __('Order sort attribute ascending or descending.'),
			'type' => 'string',
			'default' => 'asc',
			'enum' => array(
				'asc',
				'desc',
			),
		);

		$query_params['orderby'] = array(
			'description' => __('Sort collection by term attribute.'),
			'type' => 'string',
			'default' => 'name',
			'enum' => array(
				'id',
				'include',
				'name',
				'slug',
				'term_group',
				'description',
				'count',
			),
		);

		$query_params['hide_empty'] = array(
			'description' => __('Whether to hide terms not assigned to any posts.'),
			'type' => 'boolean',
			'default' => false,
		);

		$query_params['parent'] = array(
			'description' => __('Limit result set to terms assigned to a specific parent.'),
			'type' => 'integer',
		);

//        $query_params['post'] = array(
		//            'description'       => __( 'Limit result set to terms assigned to a specific post.' ),
		//            'type'              => 'integer',
		//            'default'           => null,
		//        );
		//
		//        $query_params['slug'] = array(
		//            'description'       => __( 'Limit result set to terms with one or more specific slugs.' ),
		//            'type'              => 'array',
		//            'items'             => array(
		//                'type'          => 'string'
		//            ),
		//        );

		$query_params['courses_limit'] = array(
			'description' => __('Limit result set to Course of terms with one or more specific slugs.'),
			'type' => 'integer',
			'default' => 5,
		);

		return $query_params;
	}

	/**
	 * Prepare Links for the request
	 * @param $data array item object
	 *
	 * @return array Links for given data
	 */
	protected function prepare_links($data) {

		$base = $this->namespace . '/' . $this->rest_base;

		return array(
			'self' => array(
				'href' => rest_url(trailingslashit($base) . $data["id"]),
			),
			'collection' => array(
				'href' => rest_url($base),
			),
		);
	}

}
