<?php
namespace BuddyBossApp\Api\Learner;
use WP_Error;
use WP_REST_Request;
use WP_REST_Server;

// NOTE : Old classname was class.bbapp_learner_statement_rest. By Ketan, Oct-2019
// (v1 Standard) Contain functionality for required additional rest api endpoints for learndash.
class StatementRest extends Rest {

	protected static $instance;

	/**
	 * StatementRest constructor.
	 */
	public function __construct() {
		$this->rest_base = 'statement';
		parent::__construct();
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if (!isset(self::$instance)) {
			$class = __CLASS__;
			self::$instance = new $class;
		}

		return self::$instance;
	}

	/**
	 * @return void|WP_Error
	 */
	public function register_routes() {

		register_rest_route($this->namespace, '/' . $this->rest_base, array(
			array(
				'methods' => WP_REST_Server::EDITABLE,
				'callback' => array($this, 'upload_progress'),
				'permission_callback' => '__return_true',
				'args' => array(
				),
			),
		));
	}

	/**
	 * @param $request
	 * @return array|WP_Error
     * @apiPrivate
	 * @api {PATCH} /wp-json/appboss/learner/v1/statement Upload statement
	 * @apiName UploadLearnerStatementCourseProgress
	 * @apiGroup LearnerStatement
	 * @apiVersion 1.0.0
	 * @apiPermission LoggedInUser
	 * @apiDescription Upload statement
	 * @apiHeader {String} accessToken Auth token
	 * @apiParam {Array} statements[] Statements array consists of variety of values(key-value pair). See below params within it.
	 * @apiParam {String=completed} statements[action] Under statements[] param. Note : key must be inside double quote, can't document here because of apidoc limitation.
	 * @apiParam {String=lesson,topic} statements[object] Under statements[] param. Note : key must be inside double quote, can't document here because of apidoc limitation.
	 * @apiParam {String} statements[data] Under statements[] param. Note : key must be inside double quote, can't document here because of apidoc limitation.
	 * @apiParam {Number} statements[primary_item_id] Under statements[] param. Note : key must be inside double quote, can't document here because of apidoc limitation.
	 * @apiParam {Number} statements[item_id] Under statements[] param. Note : key must be inside double quote, can't document here because of apidoc limitation.
	 * @apiDeprecated  Process Course Statements. Check (#Statements:PostLDCourseStatements)
	 */
	public function upload_progress($request) {
		$responses = array();

		if (!is_user_logged_in()) {
			return new WP_Error('rest_not_logged_in', __('You are not currently logged in.'), array('status' => rest_authorization_required_code()));
		}

		$statements = (array) $request['statements'];
		$_temp = $_REQUEST;

		foreach ($statements as $statement) {
			$action = $statement['action'];
			$object = $statement['object'];
			$object_data = $statement['data'];

			if ('completed' == $action) {
				switch ($object) {
				case 'lesson':
					$course_id = (int) $statement['primary_item_id'];
					$lesson_id = (int) $statement['item_id'];

					$lesson_request = new WP_REST_Request('POST', '/appboss/learner/v1/lessons/complete/' . $lesson_id);

					$lesson_request->set_url_params(array('id' => $lesson_id));
					$lesson_request->set_param('course_id', $course_id);
					$lesson_request->set_body($object_data);
					if (!empty($object_data)) {
						foreach ($object_data as $key => $data) {
							$lesson_request->set_param($key, $data);
						}
					}

					$_GET = $_POST = $_REQUEST = $lesson_request->get_params();
					$_temp_file = $_FILES;
					if (isset($_FILES[$lesson_id])) {
						$_FILES = $_FILES[$lesson_id];
					} else {
						unset($_FILES);
					}
					$_FILES = $_temp_file;

					$server = rest_get_server();
					$responses[] = $server->dispatch($lesson_request);

					break;
				case 'topic':

					$course_id = (int) $statement['primary_item_id'];
					$lesson_id = (int) $statement['secondary_item_id'];
					$topic_id = (int) $statement['item_id'];

					$topic_request = new WP_REST_Request('POST', '/appboss/learner/v1/topics/complete/' . $topic_id);

					$topic_request->set_url_params(array('id' => $topic_id));
					$topic_request->set_param('course_id', $course_id);
					$topic_request->set_param('lesson_id', $lesson_id);
					$topic_request->set_body($object_data);
					if (!empty($object_data)) {
						foreach ($object_data as $key => $data) {
							$topic_request->set_param($key, $data);
						}
					}

					$_GET = $_POST = $_REQUEST = $topic_request->get_params();
					$_temp_file = $_FILES;
					if (isset($_FILES[$topic_id])) {
						$_FILES = $_FILES[$topic_id];
					} else {
						unset($_FILES);
					}
					$_FILES = $_temp_file;

					$server = rest_get_server();
					$responses[] = $server->dispatch($topic_request);

					break;
				}
			}
		}

		$_GET = $_POST = $_REQUEST = $_temp;

		return $responses;
	}
}