<?php
namespace BuddyBossApp\Api\Learner;

// @todo - This need to have namespace and PSR-4 standards. By Ketan, Apr-2019

// Make sure we don't expose any info if called directly
if (!function_exists('add_action')) {
	die("Sorry, you can't access this directly - Security established");
}

use BuddyBossApp\Api\Learner\BadgesRest;
use BuddyBossApp\Api\Learner\CertificatesRest;
use BuddyBossApp\Api\Learner\CourseCategoriesRest;
use BuddyBossApp\Api\Learner\CoursesRest;
use BuddyBossApp\Api\Learner\LessonsRest;
use BuddyBossApp\Api\Learner\QuizLeaderboardRest;
use BuddyBossApp\Api\Learner\QuizQuestionsRest;
use BuddyBossApp\Api\Learner\QuizRest;
use BuddyBossApp\Api\Learner\StatementRest;
use BuddyBossApp\Api\Learner\ThemeSupport;
use BuddyBossApp\Api\Learner\TopicsRest;
use BuddyBossApp\Api\Learner\UserRest;

class Main {

	public $c; //contain the classes

    private static $instance;

    /**
     * Get the instance of the class.
     *
     * @return Main
     */
    public static function instance() {
        if (!isset(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class;
            self::$instance->_load();
        }

        return self::$instance;
    }

	/**
	 * Main constructor.
	 */
	public function __construct() {}

	/**
	 *
	 */
	public function _load() {

		$this->c = new \stdClass();

		// Register all hooks.
		$this->hooks();

	}

	/**
	 * Register all hooks
	 * @since 1.0.0
	 * @return void
	 */
	public function hooks() {
		add_action('plugins_loaded', array($this, "loadRest"));
	}

	/**
	 *
	 */
	public function loadRest() {

		if (!defined('LEARNDASH_VERSION') || version_compare(LEARNDASH_VERSION, '3.1', '<')) {
			// don't load if leanrdash is not enabled.
			return false;
		}

		require_once dirname( __FILE__ ) . '/functions.php';
		require_once dirname( __FILE__ ) . '/filters-n-actions.php';

		StatementRest::instance();
		CoursesRest::instance();
		LessonsRest::instance();
		TopicsRest::instance();
		CertificatesRest::instance();
		BadgesRest::instance();
		CourseCategoriesRest::instance();
		QuizRest::instance();
		QuizQuestionsRest::instance();
		QuizLeaderboardRest::instance();
		//UserRest::instance();

		// NOTE V2 class below
        //BuddyBossAppLearnerRest::instance();
        //BuddyBossAppLearnerCoursesRest::instance();
        //LearnerCoursesRest::instance();
	}
}
