<?php
if (!defined('ABSPATH')) {
	exit();
}
use \LearnDash_Custom_Label as LearnDash_Custom_Label;
use \LearnDash_Settings_Section as LearnDash_Settings_Section;
use BuddyBossApp\Api\Learner\LearnDash\QuizComplete;

/*
     * Easy to call function.
*/
if ( ! function_exists('bbapp_learner_learndash') ) {
	function bbapp_learner_learndash() {
		return \BuddyBossApp\Api\Learner\LearnDash\Main::instance();
	}
}

if (!function_exists('bbapp_lms_is_content_access')) {
	function bbapp_lms_is_content_access($obj_post, $field_name) {
		$course_id = bbapp_learndash_get_course_id($obj_post->ID);
		$user_id = get_current_user_id();
		$logged_in = !empty($user_id);
		if ($logged_in) {
			if (learndash_is_admin_user($user_id)) {
				$bypass_course_limits_admin_users = LearnDash_Settings_Section::get_section_setting('LearnDash_Settings_Section_General_Admin_User', 'bypass_course_limits_admin_users');
				if ($bypass_course_limits_admin_users == 'yes') {
					$bypass_course_limits_admin_users = true;
				} else {
					$bypass_course_limits_admin_users = false;
				}

			} else {
				$bypass_course_limits_admin_users = false;
			}

			// For logged in users to allow an override filter.
			$bypass_course_limits_admin_users = apply_filters('learndash_prerequities_bypass', $bypass_course_limits_admin_users, $user_id, $course_id, $obj_post);

		} else {
			$bypass_course_limits_admin_users = true;
		}

		if ('prerequities_completed' === $field_name) {
			return (!$logged_in) || learndash_is_course_prerequities_completed($course_id) || $bypass_course_limits_admin_users;
		} elseif ('points_access' === $field_name) {
			return (!$logged_in) || learndash_check_user_course_points_access($course_id, $user_id) || $bypass_course_limits_admin_users;
		}

		if ('previous_lesson_completed' === $field_name || 'previous_topic_completed' === $field_name) {
			$lesson_progression_enabled = bbapp_learndash_get_course_meta_setting($course_id, 'course_disable_lesson_progression');
			$previous_completed = true;
			if (empty($lesson_progression_enabled)) {
				if ((learndash_is_admin_user($user_id)) && ($bypass_course_limits_admin_users)) {
					$previous_completed = true;
				} else {
					if ('previous_lesson_completed' === $field_name) {
						if ('sfwd-topic' === $obj_post->post_type) {
							$lesson_id = learndash_get_setting($obj_post->ID, 'lesson');
							$lesson_post = get_post($lesson_id);
						} else {
							$lesson_post = $obj_post;
						}
						if (!empty($lesson_post)) {
							$previous_completed = apply_filters('learndash_previous_step_completed', is_previous_complete($lesson_post), $lesson_post->ID, $user_id);
						}
					} elseif ('previous_topic_completed' === $field_name) {
						$previous_completed = apply_filters('learndash_previous_step_completed', is_previous_complete($obj_post), $obj_post->ID, $user_id);
					}
				}
			}
			return (bool) $previous_completed;
		}
		return false;
	}
}

if (!function_exists('bbapp_lms_lesson_access_from')) {
	function bbapp_lms_lesson_access_from($obj_post, $bool_return = true) {
		$course_id = bbapp_learndash_get_course_id($obj_post->ID);
		$user_id = get_current_user_id();

		$bypass_course_limits_admin_users = false;
		if (learndash_is_admin_user($user_id)) {
			$bypass_course_limits_admin_users = LearnDash_Settings_Section::get_section_setting('LearnDash_Settings_Section_General_Admin_User', 'bypass_course_limits_admin_users');
			if ($bypass_course_limits_admin_users == 'yes') {
				$bypass_course_limits_admin_users = true;
			} else {
				$bypass_course_limits_admin_users = false;
			}

		}

		$lesson_access_from = ld_lesson_access_from($obj_post->ID, $user_id, $course_id);
		if ((!empty($lesson_access_from)) && (!$bypass_course_limits_admin_users)) {
			if (!$bool_return) {
				return $lesson_access_from;
			}
			return false;
		}
		return true;
	}
}

if (!function_exists('bbapp_lms_next_lesson_id')) {
	function bbapp_lms_next_lesson_id($post) {
		if (empty($post->ID)) {
			return '';
		}
		$next = bbapp_lms_next_post_id($post);
		if (!empty($next)) {
			$next_id = $next;
		} else {
			if ($post->post_type == 'sfwd-topic') {
				$next_id = learndash_get_setting($post, 'lesson');
			} else {
				$next_id = bbapp_learndash_get_course_id($post);
			}
		}

		if (!empty($next_id)) {
			return $next_id;
		} else {
			return '';
		}
	}
}

if (!function_exists('bbapp_lms_next_post_id')) {
	function bbapp_lms_next_post_id($post) {
		if (empty($post->ID)) {
			return '';
		}
		if ($post->post_type == 'sfwd-lessons') {
			$link_name = sprintf(_x('Next %s', 'Next Lesson Label', 'learndash'), LearnDash_Custom_Label::get_label('lesson'));
			$course_id = bbapp_learndash_get_course_id($post);
			$posts = learndash_get_lesson_list($course_id);
		} else if ($post->post_type == 'sfwd-topic') {
			$link_name = sprintf(_x('Next %s', 'Next Topic Label', 'learndash'), LearnDash_Custom_Label::get_label('topic'));
			$lesson_id = learndash_get_setting($post, 'lesson');
			$posts = learndash_get_topic_list($lesson_id);
		} else {
			return '';
		}

		foreach ($posts as $k => $p) {

			if ($p instanceof WP_Post) {
				if ($p->ID == $post->ID) {
					$found_at = $k;
					break;
				}
			}
		}

		if (isset($found_at) && !empty($posts[$found_at + 1])) {
			return $posts[$found_at + 1]->ID;
		}
		return '';
	}
}

if (!function_exists('bbapp_lms_quiz_completed')) {
	function bbapp_lms_quiz_completed($post) {
		$quizzes = learndash_get_lesson_quiz_list($post);
		$quizids = array();

		if (!empty($quizzes)) {
			foreach ($quizzes as $quiz) {
				$quizids[$quiz['post']->ID] = $quiz['post']->ID;
			}
		}

		if (!empty($quizids)) {
			$all_quizzes_completed = !learndash_is_quiz_notcomplete(null, $quizids);
		} else {
			$all_quizzes_completed = true;
		}

		return $all_quizzes_completed;
	}
}

if (!function_exists('bbapp_lms_media_upload_dir')) {
	function bbapp_lms_media_upload_dir($param) {

		$param['path'] = $param['basedir'] . '/assignments';
		$param['url'] = $param['baseurl'] . '/assignments';

		return $param;
	}
}

/**
 * Ref_Files: sfwd-lms/includes/ld-assignment-uploads.php
 * Ref_Funcation: learndash_upload_assignment_init
 */
if (!function_exists('bbapp_lms_upload_assignment_init')) {
	function bbapp_lms_upload_assignment_init($post_id, $fname) {
		//Initialize an empty array
		global $wp;

		if (!function_exists('wp_get_current_user')) {
			include ABSPATH . 'wp-includes/pluggable.php';
		}

		$new_assignmnt_meta = array();
		$current_user = wp_get_current_user();
		$username = $current_user->user_login;
		$dispname = $current_user->display_name;
		$userid = $current_user->ID;
		$url_link_arr = wp_upload_dir();
		$url_link = $url_link_arr['baseurl'];
		$dir_link = $url_link_arr['basedir'];
		$file_path = $dir_link . '/assignments/';
		$url_path = $url_link . '/assignments/' . $fname;

		if (file_exists($file_path . $fname)) {
			$dest = $url_path;
		} else {
			return;
		}

		update_post_meta($post_id, 'sfwd_lessons-assignment', $new_assignmnt_meta);
		$post = get_post($post_id);
		$course_id = bbapp_learndash_get_course_id($post->ID);

		$assignment_meta = array(
			'file_name' => $fname,
			'file_link' => $dest,
			'user_name' => $username,
			'disp_name' => $dispname,
			'file_path' => rawurlencode($file_path . $fname),
			'user_id' => $current_user->ID,
			'lesson_id' => $post->ID,
			'course_id' => $course_id,
			'lesson_title' => $post->post_title,
			'lesson_type' => $post->post_type,
		);

		$points_enabled = learndash_get_setting($post, 'lesson_assignment_points_enabled');

		if ($points_enabled == 'on') {
			$assignment_meta['points'] = 'Pending';
		}

		$assignment = array(
			'post_title' => $fname,
			'post_type' => 'sfwd-assignment',
			'post_status' => 'publish',
			'post_content' => "<a href='" . $dest . "' target='_blank'>" . $fname . '</a>',
			'post_author' => $current_user->ID,
		);

		$assignment_post_id = wp_insert_post($assignment);

		if ($assignment_post_id) {
			foreach ($assignment_meta as $key => $value) {
				update_post_meta($assignment_post_id, $key, $value);
			}

			/**
			 * Run action hook after assignment is uploaded
			 *
			 * @since 2.2
			 *
			 * @param int 		$assignment_post_id 	Newly created assignment post ID which the
			 *                                 	 		assignment is uploaded to
			 * @param array 	$assignment_meta 		Assignment meta data
			 */
			do_action('learndash_assignment_uploaded', $assignment_post_id, $assignment_meta);
		}

		$auto_approve = learndash_get_setting($post, 'auto_approve_assignment');

		if (!empty($auto_approve)) {
			learndash_approve_assignment($current_user->ID, $post_id);

			// assign full points if auto approve & points are enabled
			if ($points_enabled == 'on') {
				$points = learndash_get_setting($post, 'lesson_assignment_points_amount');
				update_post_meta($assignment_post_id, 'points', intval($points));
			}

			return true;
		} else {
			return new WP_Error('learndash_attachment_need_approve', __('Assignment uploaded. Once approved, the associated lesson will be completed automatically.', 'buddyboss-app'), array('status' => 400));
		}
	}
}

/**
 * Ref_Files: badgeos/includes/achievement-functions.php:577
 * Ref_Funcation: badgeos_get_achievement_post_thumbnail
 */
if (!function_exists('bbapp_lms_badgeos_get_achievement_post_thumbnail_url')) {
	function bbapp_lms_badgeos_get_achievement_post_thumbnail_url($post_id = 0, $image_size = 'badgeos-achievement', $class = 'badgeos-item-thumbnail') {
		// Get our badge thumbnail
		$image_url = get_the_post_thumbnail_url($post_id, $image_size);
		// If we don't have an image...
		if (!$image_url) {

			// Grab our achievement type's post thumbnail
			$achievement = get_page_by_path(get_post_type($post_id), OBJECT, 'achievement-type');
			$image = is_object($achievement) ? get_the_post_thumbnail_url($achievement->ID, $image_size) : false;

			// If we still have no image, use one from Credly
			if (!$image) {
				// Available filter: 'badgeos_default_achievement_post_thumbnail'
				$image_url = apply_filters('badgeos_default_achievement_post_thumbnail', 'https://credlyapp.s3.amazonaws.com/badges/af2e834c1e23ab30f1d672579d61c25a_15.png');

			}
		}

		// Finally, return our image tag
		return $image_url;
	}
}

/**
 * Ref_Files: gamipress/includes/achievement-functions.php:732
 * Ref_Funcation: gamipress_get_achievement_post_thumbnail
 */
if (!function_exists('bbapp_gamipress_get_achievement_post_thumbnail_url')) {
	function bbapp_gamipress_get_achievement_post_thumbnail_url($post_id = 0, $image_size = 'gamipress-achievement', $class = 'gamipress-achievement-thumbnail') {

		// Get our badge thumbnail
		$image_url = get_the_post_thumbnail_url($post_id, $image_size);
		// If we don't have an image...
		if (!$image_url) {

			// Grab our achievement type's post thumbnail
			$achievement = get_page_by_path(gamipress_get_post_type($post_id), OBJECT, 'achievement-type');
			$image = is_object($achievement) ? get_the_post_thumbnail_url($achievement->ID, $image_size) : false;

			// If we still have no image, use one from Credly
			if (!$image) {
				// Available filter: 'badgeos_default_achievement_post_thumbnail'
				$image_url = apply_filters('gamipress_default_achievement_post_thumbnail', 'https://credlyapp.s3.amazonaws.com/badges/af2e834c1e23ab30f1d672579d61c25a_15.png', $achievement);

			}
		}

		// Finally, return our image tag
		return $image_url;
	}
}

/**
 * Ref_Files: sfwd-lms/includes/vendor/wp-pro-quiz/lib/view/WpProQuiz_View_FrontQuiz.php
 * Ref_Funcation: fetchCloze
 */
if (!function_exists('bbapp_lms_fetchCloze')) {

	function bbapp_lms_fetchCloze($answer_text) {
		preg_match_all('#\{(.*?)(?:\|(\d+))?(?:[\s]+)?\}#im', $answer_text, $matches, PREG_SET_ORDER);

		$data = array();

		foreach ($matches as $k => $v) {
			$text = $v[1];
			$points = !empty($v[2]) ? (int) $v[2] : 1;
			$rowText = $multiTextData = array();
			$len = array();

			if (preg_match_all('#\[(.*?)\]#im', $text, $multiTextMatches)) {
				foreach ($multiTextMatches[1] as $multiText) {
					if (function_exists('mb_strtolower')) {
						$x = mb_strtolower(trim(html_entity_decode($multiText, ENT_QUOTES)));
					} else {
						$x = strtolower(trim(html_entity_decode($multiText, ENT_QUOTES)));
					}

					$len[] = strlen($x);
					$multiTextData[] = $x;
					$rowText[] = $multiText;
				}
			} else {
				if (function_exists('mb_strtolower')) {
					$x = mb_strtolower(trim(html_entity_decode($text, ENT_QUOTES)));
				} else {
					$x = strtolower(trim(html_entity_decode($text, ENT_QUOTES)));
				}

				$len[] = strlen($x);
				$multiTextData[] = $x;
				$rowText[] = $text;
			}

			$a = '<span class="wpProQuiz_cloze"><input data-wordlen="' . max($len) . '" type="text" value=""> ';
			$a .= '<span class="wpProQuiz_clozeCorrect" style="display: none;"></span></span>';

			$data['correct'][] = $multiTextData;
			$data['points'][] = $points;
			$data['data'][] = $a;
		}

		$data['replace'] = preg_replace('#\{(.*?)(?:\|(\d+))?(?:[\s]+)?\}#im', '@@wpProQuizCloze@@', $answer_text);

		return $data;
	}
}

/**
 * Ref_Files: sfwd-lms/includes/vendor/wp-pro-quiz/lib/view/WpProQuiz_View_FrontQuiz.php
 * Ref_Funcation: fetchAssessment
 */
if (!function_exists('bbapp_lms_fetchAssessment')) {
	function bbapp_lms_fetchAssessment($answerText) {
		preg_match_all('#\{(.*?)\}#im', $answerText, $matches);

		$data = array();
		$data['assessmetTemp'] = array();

		for ($i = 0, $ci = count($matches[1]); $i < $ci; $i++) {
			$match = $matches[1][$i];
			preg_match_all('#\[([^\|\]]+)(?:\|(\d+))?\]#im', $match, $ms);
			for ($j = 0, $cj = count($ms[1]); $j < $cj; $j++) {
				$v = $ms[1][$j];
				$data['assessmetTemp'][$i][] = array('text' => $v, 'val' => $j + 1);
			}
		}

		$data['replace'] = preg_replace('#\{(.*?)\}#im', '@@wpProQuizAssessment@@', $answerText);

		return $data;
	}
}

/**
 * Ref_Files: sfwd-lms/includes/vendor/wp-pro-quiz/lib/controller/WpProQuiz_Controller_Admin.php
 * Ref_Funcation: completedQuiz
 */
if (!function_exists('bbapp_lms_completedQuiz')) {
	function bbapp_lms_completedQuiz() {

		// First we unpack the $_POST['results'] string
		if ((isset($_POST['results'])) && (!empty($_POST['results'])) && (is_string($_POST['results']))) {
			$_POST['results'] = json_decode(stripslashes($_POST['results']), true);
		}

		if (is_user_logged_in()) {
			$user_id = get_current_user_id();
		} else {
			$user_id = 0;
		}

		if (isset($_POST['quizId'])) {
			$id = $_POST['quizId'];
		} else {
			$id = 0;
		}

		if (isset($_POST['quiz'])) {
			$quiz_post_id = $_POST['quiz'];
		} else {
			$quiz_post_id = 0;
		}

		// LD 2.4.3 - Change in logic. Instead of accepting the values for points, correct etc from JS we now pass the 'results' array on the complete quiz
		// AJAX action. This now let's us verify the points, correct answers etc. as each have a unique nonce.
		$total_awarded_points = 0;
		$total_correct = 0;

		// If the results is not present then abort.
		if (!isset($_POST['results'])) {
			return array('text' => __('An error has occurred.', 'wp-pro-quiz'), 'clear' => true);
		}

		// Loop over the 'results' items. We verify and tally the points+correct counts as well as the student response 'data'. When we get to the 'comp' results element
		// we set the award points and correct as well as determine the total possible points.
		// @TODO Need to test how this works with variabel question quizzes.
		foreach ($_POST['results'] as $r_idx => $result) {
			if ($r_idx == 'comp') {
				$_POST['results'][$r_idx]['points'] = intval($total_awarded_points);
				$_POST['results'][$r_idx]['correctQuestions'] = intval($total_correct);

				//$quizMapper = new WpProQuiz_Model_QuizMapper();
				//$total_possible_points = $quizMapper->sumQuestionPoints( $id );
				//$_POST['results'][$r_idx]['possiblePoints'] = intval( $total_possible_points );
				//$_POST['results'][$r_idx]['result'] = round( intval( $_POST['results'][$r_idx]['points'] ) / intval( $_POST['results'][$r_idx]['possiblePoints'] ) * 100, 2 );

				continue;
			}

			$points_array = array(
				'points' => intval($result['points']),
				'correct' => intval($result['correct']),
				'possiblePoints' => intval($result['possiblePoints']),
			);
			if ($points_array['correct'] === false) {
				$points_array['correct'] = 0;
			} else if ($points_array['correct'] === true) {
				$points_array['correct'] = 1;
			}

			$points_str = maybe_serialize($points_array);

			if (!wp_verify_nonce($result['p_nonce'], 'ld_quiz_pnonce' . $user_id . '_' . $id . '_' . $quiz_post_id . '_' . $r_idx . '_' . $points_str)) {
				$_POST['results'][$r_idx]['points'] = 0;
				$_POST['results'][$r_idx]['correct'] = 0;
				$_POST['results'][$r_idx]['possiblePoints'] = 0;
			}
			$total_awarded_points += intval($_POST['results'][$r_idx]['points']);
			$total_correct += $_POST['results'][$r_idx]['correct'];
			$response_str = maybe_serialize($result['data']);

			if (!wp_verify_nonce($result['a_nonce'], 'ld_quiz_anonce' . $user_id . '_' . $id . '_' . $quiz_post_id . '_' . $r_idx . '_' . $response_str)) {
				$_POST['results'][$r_idx]['data'] = array();
			}
		}

		$quiz = new QuizComplete();
		return $quiz->completedQuiz();
	}
}

if (!function_exists('bbapp_lms_taxonomy_image_url')) {
	function bbapp_lms_taxonomy_image_url($term_id = NULL, $size = 'full', $return_placeholder = FALSE) {
		if (function_exists('bbapp_taxonomy_custom_icon_url')) {
			return bbapp_taxonomy_custom_icon_url($term_id, $size, $return_placeholder);
		}
	}
}

if (!function_exists('bbapp_learndash_get_course_id')) {
	function bbapp_learndash_get_course_id($id = null, $bypass_cb = false) {
		global $post, $wpdb;

		// Somewhat a kludge. Here we try ans assume the course_id being handled.
		if ((LearnDash_Settings_Section::get_section_setting('LearnDash_Settings_Courses_Builder', 'shared_steps') == 'yes') && ($bypass_cb === false)) {

			if ((isset($_GET['course_id'])) && (!empty($_GET['course_id']))) {
				return intval($_GET['course_id']);
			} else if ((isset($_POST['course_id'])) && (!empty($_POST['course_id']))) {
				return intval($_POST['course_id']);
			} else if ((isset($_GET['post'])) && (!empty($_GET['post']))) {
				if (get_post_type(intval($_GET['post'])) == 'sfwd-courses') {
					return intval($_GET['post']);
				}
			} else {
				//get first course id
				if (is_object($id) && $id->ID) {
					$id = $id->ID;
				}
				if (is_numeric($id)) {
					$course_id = $wpdb->get_var($wpdb->prepare("SELECT `meta_value` FROM $wpdb->postmeta WHERE `post_id` = %d AND `meta_key`", $id) . "LIKE '%ld_course_%' ORDER BY `meta_id` DESC LIMIT 1");
					if (!empty($course_id)) {
						return $course_id;
					}
				}
			}
		}

		if (is_object($id) && $id->ID) {
			$p = $id;
			$id = $p->ID;
		} else if (is_numeric($id)) {
			$p = get_post($id);
		}

		if (empty($p->ID)) {
			return 0;
		}

		if ($p->post_type == 'sfwd-courses') {
			return $p->ID;
		}

		return get_post_meta($id, 'course_id', true);
	}
}

if (!function_exists('bbapp_learndash_get_lesson_id')) {
	function bbapp_learndash_get_lesson_id($post_id = null, $course_id = null) {
		global $post;

		if (LearnDash_Settings_Section::get_section_setting('LearnDash_Settings_Courses_Builder', 'shared_steps') == 'yes') {
			if (empty($course_id)) {
				$course_id = bbapp_learndash_get_course_id($post_id);
			}

			if (!empty($course_id)) {
				return learndash_course_get_single_parent_step($course_id, $post_id);
			}
		}

		return get_post_meta($post_id, 'lesson_id', true);
	}
}

if (!function_exists("bbapp_learndash_fix_html")) {

	/**
	 * Function unclosed fixes the provided html.
	 * Dom feature is not exists it will trim html and provide plain text.
	 *
	 * @param $html
	 *
	 * @return string
	 */
	function bbapp_learndash_fix_html($html) {
		if (!class_exists("DOMDocument")) {
			return strip_tags($html);
		}
		$doc = new \DOMDocument();
		@$doc->loadHTML('<?xml encoding=\"utf-8\" ?>' . $html);
		$body = $doc->documentElement->lastChild;

		$html = '';
		foreach ($body->childNodes as $node) {
			$html .= $doc->saveHTML($node);
		}
		return $html;

	}

}

if (!function_exists("bbapp_learndash_get_course_meta_setting")) {
	/**
	 * Deprecated support for get_course_meta_setting
	 * @param $course_id
	 * @param $setting_key
	 */
	function bbapp_learndash_get_course_meta_setting($course_id, $setting_key) {
		if (function_exists('learndash_get_course_meta_setting')) {
			return learndash_get_course_meta_setting($course_id, $setting_key);
		} else {
			return get_course_meta_setting($course_id, $setting_key);
		}
	}
}

if ( ! function_exists( 'is_rest' ) ){
    /**
     * This will check request is rest or not.
     * @return bool
     */
    function is_rest(){
        return ( strpos($_SERVER[ 'REQUEST_URI' ], '/wp-json') !== false );
    }
}

if (!function_exists("bbapp_learndash_remove_filters_for_anonymous_class")) {
    /**
     * This function is Created to remove hook of Wordpress using classNme instead of class object.
     *
     * @param $tag
     * @param $class
     * @param $method
     */
    function bbapp_learndash_remove_filters_for_anonymous_class($tag, $class, $method)
    {
        $filters = $GLOBALS['wp_filter'][$tag];
        if (empty ($filters)) {
            return;
        }
        foreach ($filters as $priority => $filter) {
            foreach ($filter as $identifier => $function) {
                if (is_array($function)
                    and is_a($function['function'][0], $class)
                    and $method === $function['function'][1]
                ) {
                    remove_filter(
                        $tag,
                        array($function['function'][0], $method),
                        $priority
                    );
                }
            }
        }
    }
}