<?php
namespace BuddyBossApp\Api\Learner\LearnDash;
use WpProQuiz_Model_Quiz;
use WpProQuiz_Model_QuizMapper;
use WpProQuiz_Model_Toplist;
use WpProQuiz_Model_ToplistMapper;
use WP_Error;
use WpProQuiz_Helper_Until;

// NOTE : Old classname was class.bbapp_learner_learndash_quiz_leaderboard_rest. By Ketan, Oct-2019
// Contain functionality for required additional rest api endpoints for learndash - v1 Standard
class QuizLeaderboardRest {

	public $post_type = 'sfwd-quiz';

	/**
	 * QuizLeaderboardRest constructor.
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 *
	 */
	public function hooks() {
		//add_filter('bbapp_learner_get_quiz_leaderboard', array($this, "get_lists"), 10, 3);
		//add_filter('bbapp_learner_save_quiz_leaderboard_item', array($this, "save_item"), 10, 2);
	}

	/**
	 * @param $results
	 * @param $query_args
	 * @param $request
	 *
	 * @return array
	 */
	public function get_lists($results, $query_args, $request) {
		$quiz_id = (int) $query_args['quiz_id'];

		$toplistMapper = new WpProQuiz_Model_ToplistMapper();

		$quiz_settings = learndash_get_setting($quiz_id);
		$quiz_pro = $quiz_settings['quiz_pro'];
		$quizMapper = new WpProQuiz_Model_QuizMapper();
		$quiz = $quizMapper->fetch($quiz_pro);

		$total_results = $toplistMapper->count($quiz_pro);

		$query_params = $request->get_query_params();
		if (!isset($query_params['per_page'])) {
			$query_args['per_page'] = $quiz->getToplistDataShowLimit();
		}

		$per_page = $query_args['per_page'];
		$offset = $query_args['per_page'] * ($query_args['paged'] - 1);

		$toplist = $toplistMapper->fetch($quiz_pro, $per_page, $quiz->getToplistDataSort(), $offset);

		foreach ($toplist as $tp) {
			$results[] = (object) array(
				'ID' => $tp->getToplistId(),
				'name' => $tp->getName(),
				'date' => WpProQuiz_Helper_Until::convertTime($tp->getDate(), get_option('wpProQuiz_toplistDataFormat', 'Y/m/d g:i A')),
				'point' => $tp->getPoints(),
				'result' => $tp->getResult(),
			);
		}

		return array('posts' => $results, 'total_posts' => $total_results);
	}

	/**
	 * @param $quiz_id
	 * @param $request
	 *
	 * @return bool|WP_Error
	 */
	public function save_item($quiz_id, $request) {
		$quiz_settings = learndash_get_setting($quiz_id);
		$quiz_pro = $quiz_settings['quiz_pro'];
		$quizMapper = new WpProQuiz_Model_QuizMapper();
		$quiz = $quizMapper->fetch($quiz_pro);

		$point = isset($request['point']) ? (int) $request['point'] : false;
		$result = isset($request['result']) ? $request['result'] : false;

		if ($point === false) {
			return new WP_Error('learndash_json_quiz_leaderboard_missing', __('Point data missing.', 'buddyboss-app'), array('status' => 400));
		}

		if ($result === false) {
			return new WP_Error('learndash_json_quiz_leaderboard_missing', __('Result data missing.', 'buddyboss-app'), array('status' => 400));
		}

		return $this->createitem($quiz, array('point' => $point, 'result' => $result, 'ip' => ''));
	}

	/**
	 * @param $quiz
	 * @param $data
	 *
	 * @return bool|WP_Error
	 */
	public function createitem($quiz, $data) {

		$userId = get_current_user_id();
		$user = wp_get_current_user();
		$email = $user->user_email;
		$name = $user->display_name;
		$ip = $data['ip'];
		$point = $data['point'];
		$result = $data['result'];

		$toplistMapper = new WpProQuiz_Model_ToplistMapper();

		if ($quiz == null || $quiz->getId() == 0 || !$quiz->isToplistActivated()) {
			return new WP_Error('learndash_json_quiz_leaderboard_error', __('An error has occurred.', 'buddyboss-app'), array('status' => 400));
		}

		if (!$this->preCheck($quiz->getToplistDataAddPermissions(), $userId)) {
			return new WP_Error('learndash_json_quiz_leaderboard_error', __('An error has occurred.', 'buddyboss-app'), array('status' => 400));
		}

		$clearTime = null;

		if ($quiz->isToplistDataAddMultiple()) {
			$clearTime = $quiz->getToplistDataAddBlock() * 60;
		}

		if ($toplistMapper->countUser($quiz->getId(), $userId, $clearTime)) {
			return new WP_Error('learndash_json_quiz_leaderboard_cant_enter', __('You cannot enter again.', 'buddyboss-app'), array('status' => 400));
		}

		$toplist = new WpProQuiz_Model_Toplist();
		$toplist->setQuizId($quiz->getId())
			->setUserId($userId)
			->setDate(time())
			->setName($name)
			->setEmail($email)
			->setPoints($point)
			->setResult(round($result, 2))
			->setIp($ip);
		$toplistMapper->save($toplist);

		return true;
	}

	/**
	 * @param $type
	 * @param $userId
	 *
	 * @return bool
	 */
	private function preCheck($type, $userId) {
		switch ($type) {
		case WpProQuiz_Model_Quiz::QUIZ_TOPLIST_TYPE_ALL:
			return true;
		case WpProQuiz_Model_Quiz::QUIZ_TOPLIST_TYPE_ONLY_ANONYM:
			return $userId == 0;
		case WpProQuiz_Model_Quiz::QUIZ_TOPLIST_TYPE_ONLY_USER:
			return $userId > 0;
		}
		return false;
	}
}