<?php
namespace BuddyBossApp\Api\Learner\LearnDash;
// @todo - This need to have namespace and PSR-4 standards. By Ketan, Apr-2019
// Make sure we don't expose any info if called directly
use BuddyBossApp\Api\Learner\LearnDash\BbpressSupport;
use BuddyBossApp\Api\Learner\LearnDash\LearndashBoss;
use BuddyBossApp\Api\Learner\LearnDash\LearndashBuddypress;
use BuddyBossApp\Api\Learner\LearnDash\LearndashCommon;
use BuddyBossApp\Api\Learner\LearnDash\MemberpressSupport;
use BuddyBossApp\Api\Learner\LearnDash\ShortcodeSupport;
use BuddyBossApp\Api\Learner\LearnDash\WcMembershipsSupport;
use stdClass as stdClass;

if (!function_exists('add_action')) {
	die("Sorry, you can't access this directly - Security established");
}

class Main {

	public $plugin_prefix; // should be char & _
	public $root_file;
	public $c; //contain the classes
    private static $instance;

    /**
     * Get the instance of the class.
     *
     * @return Build
     */
    public static function instance() {
        if (!isset(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class;
            self::$instance->_load();
        }

        return self::$instance;
    }

	/**
	 * Main constructor.
	 */
	public function __construct() {

    }

	/**
	 *
	 */
	public function _load() {

		$this->plugin_prefix = "bbapp_learner_learndash";
		$this->c = new stdClass();

		// Register all hooks.
		$this->hooks();

	}

	/**
	 * Register all hooks
	 * @since 1.0,0
	 * @return void
	 */
	public function hooks() {

		add_action('plugins_loaded', array($this, "load_rest"), 11);
		add_filter('learner_addon_class_filter', array($this, "learner_class_filter"), 10, 2);

	}

	/**
	 * @param $is_bypass
	 * @param $class_name
	 *
	 * @return bool
	 */
	public function learner_class_filter($is_bypass, $class_name) {
		if (strpos($class_name, $this->plugin_prefix) !== false) {
			return true;
		}
		return $is_bypass;
	}

	/**
	 * @return bool
	 */
	public function load_rest() {

		if (!defined('LEARNDASH_VERSION') || version_compare(LEARNDASH_VERSION, '3.1', '<')) {
			// don't load if leanrdash is not enabled.
			return false;
		}

		require_once dirname( __FILE__ ) . '/functions.php';
		require_once dirname( __FILE__ ) . '/filters-n-actions.php';


		$this->c->bbapp_learner_learndash_courses_rest = new CoursesRest();
		$this->c->bbapp_learner_learndash_lessons_rest = new LessonsRest();
		$this->c->bbapp_learner_learndash_topics_rest = new TopicsRest();
		$this->c->bbapp_learner_learndash_certificates_rest = new CertificatesRest();

		if (class_exists('BadgeOS') && class_exists('BadgeOS_LearnDash')) {
			$this->c->bbapp_learner_learndash_badges_rest = new BadgesRest();
		}

		if (class_exists('GamiPress') && class_exists('GamiPress_LearnDash')) {
			$this->c->bbapp_learner_learndash_gamipress_rest = new GamipressRest();
		}

		$this->c->bbapp_learner_learndash_courses_categories_rest = new CoursesCategoriesRest();
		$this->c->bbapp_learner_learndash_quiz_rest = new QuizRest();
		$this->c->bbapp_learner_learndash_quiz_leaderboard_rest = new QuizLeaderboardRest();
	}
}
