<?php
namespace BuddyBossApp\Api\Learner\LearnDash;
use stdClass;
use WP_Query;

// NOTE : Old classname was class.bbapp_learner_learndash_gamipress_rest. By Ketan, Oct-2019
// Contain functionality for required additional rest api endpoints for learndash - v1 Standard
class GamipressRest {

	/**
	 * GamipressRest constructor.
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 *
	 */
	public function hooks() {
		add_filter('bbapp_learner_get_badges_items_permissions', array($this, 'get_items_permissions'), 10, 2);
		add_filter('bbapp_learner_get_badges', array($this, "get_badges"), 10, 2);
		add_filter('bbapp_learner_get_ranks', array($this, "get_ranks"), 10, 2);
		add_filter('bbapp_learner_get_points', array($this, "get_points"), 10, 2);
		add_filter('bbapp_learner_get_user_points', array($this, "get_user_points"), 10, 2);
	}

	/**
	 * @param $flag
	 * @param $request
	 *
	 * @return bool
	 */
	public function get_items_permissions($flag, $request) {
		return true;
	}

	/**
	 * @param $query_args
	 * @param $request
	 *
	 * @return array
	 */
	public function get_badges($query_args, $request) {

		if (!empty($request['user_id'])) {
			$user_id = (int) $request['user_id'];
		} else {
			$user_id = get_current_user_id();
		}

		$badges = array();

		if (class_exists('GamiPress') && class_exists('GamiPress_LearnDash')) {
			// don't load if gamipress leanrdash is not enabled.
			$achivement_types = gamipress_get_achievement_types_slugs();

			$achivement_types = apply_filters('bbapp_learner_learndash_badges_types', $achivement_types);

			foreach ($achivement_types as $type) {
				$earned_ids = gamipress_get_user_earned_achievement_ids($user_id, $type);

				if (empty($earned_ids)) {
					$earned_ids = array(0);
				}

				$args = array(
					'post_type' => $type,
					'post_status' => 'publish',
					'post__in' => $earned_ids,
					'order' => isset($request['order']) ? $request['order'] : 'Desc',
					'orderby' => isset($request['orderby']) ? $request['order'] : 'date',
				);

				// Loop Achievements
				$achievement_posts = new WP_Query($args);

				if ($achievement_posts->have_posts()) {
					foreach ($achievement_posts->posts as $achievement) {

						$badge = new stdClass();
						$badge->ID = $achievement->ID;
						$badge->title = get_the_title($achievement->ID);
						$badge->link = get_permalink($achievement->ID);
						$badge->content = !empty($achievement->post_excerpt) ? $achievement->post_excerpt : $achievement->post_content;
						$badge->points = gamipress_get_post_meta($achievement->ID, '_gamipress_points', true);
						$badge->image = bbapp_gamipress_get_achievement_post_thumbnail_url($achievement->ID);
						$badges[] = $badge;
					}
				}
			}
		}

		return array('posts' => $badges);

	}

	/**
	 * @param $query_args
	 * @param $request
	 *
	 * @return array
	 */
	public function get_ranks($query_args, $request) {

		if (!empty($request['user_id'])) {
			$user_id = (int) $request['user_id'];
		} else {
			$user_id = get_current_user_id();
		}

		$ranks = array();

		if (class_exists('GamiPress') && class_exists('GamiPress_LearnDash')) {
			// don't load if gamipress leanrdash is not enabled.

			$rank_types_slugs = gamipress_get_rank_types_slugs();
			$gamipress_settings = ($exists = get_option('gamipress_settings')) ? $exists : array();
			$rank_types_order = isset($gamipress_settings['bp_members_ranks_types_order']) ?
			$gamipress_settings['bp_members_ranks_types_order'] : $rank_types_slugs;

			$rank_types = gamipress_get_rank_types();

			foreach ($rank_types_order as $rank_type_slug) {

				// Skip if rank not exists
				if (!isset($rank_types[$rank_type_slug])) {
					continue;
				}

				$user_rank = gamipress_get_user_rank($user_id, $rank_type_slug);
				$rank = new stdClass();
				$rank->ID = $user_rank->ID;
				$rank->title = get_the_title($user_rank->ID);
				$rank->link = get_permalink($user_rank->ID);
				$rank->content = !empty($user_rank->post_excerpt) ? $user_rank->post_excerpt : $user_rank->post_content;
				$rank->points = gamipress_get_post_meta($user_rank->ID, '_gamipress_points', true);
				$rank->image = bbapp_gamipress_get_achievement_post_thumbnail_url($user_rank->ID);
				$ranks[] = $rank;
			}
		}

		return array('posts' => $ranks);

	}

	/**
	 * @param $points
	 * @param $user_id
	 *
	 * @return int
	 */
	public function get_points($points, $user_id) {
		$points = 0;
		$types = gamipress_get_points_types_slugs();
		foreach ($types as $type) {
			$_point = (int) gamipress_get_user_points($user_id, $type);
			$points = $points + $_point;
		}
		return $points;
	}

	/**
	 * @param $points
	 * @param $user_id
	 *
	 * @return array
	 */
	public function get_user_points($points, $user_id) {
		$points = array();
		$points_types = gamipress_get_points_types();

		$points_types_slugs = gamipress_get_points_types_slugs();
		$gamipress_settings = ($exists = get_option('gamipress_settings')) ? $exists : array();
		$points_types_order = isset($gamipress_settings['bp_members_points_types_order']) ? $gamipress_settings['bp_members_points_types_order'] : $points_types_slugs;

		foreach ($points_types_order as $points_type_slug) {

			// Skip if rank not exists
			if (!isset($points_types[$points_type_slug])) {
				continue;
			}

			$_point = (int) gamipress_get_user_points($user_id, $points_type_slug);
			$points[] = array(
				'point' => $_point,
				'label' => $points_types[$points_type_slug]['plural_name'],
			);
		}
		return array_values($points);
	}

}