<?php
namespace BuddyBossApp\Api\Learner\LearnDash;
use WP_Error;
use WP_REST_Term_Meta_Fields;

// NOTE : Old classname was class.bbapp_learner_learndash_courses_categories_rest. By Ketan, Oct-2019
// Contain functionality for required additional rest api endpoints for learndash - v1 Standard
class CoursesCategoriesRest {

	public $taxonomy = 'ld_course_category';
	public $meta;

	/**
	 * CoursesCategoriesRest constructor.
	 */
	public function __construct() {
		$this->meta = new WP_REST_Term_Meta_Fields($this->taxonomy);
		$this->hooks();
	}

	/**
	 *
	 */
	public function hooks() {

		add_filter('bbapp_learner_get_course-categories_items_permissions', array($this, 'get_items_permissions'), 10, 2);
		add_filter('bbapp_learner_get_course-categories_item_permissions', array($this, 'get_item_permissions'), 10, 2);
		add_filter('bbapp_learner_get_course-categories_taxonomy_allowed', array($this, 'get_taxonomy_allowed'), 10, 2);

		//add_filter('bbapp_learner_get_course_categories', array($this, "get_course_categories"), 10, 3);
		//add_filter('bbapp_learner_get_course_category', array($this, "get_course_category"), 10, 3);
	}

	/**
	 * @param $flag
	 * @param $request
	 *
	 * @return bool|WP_Error
	 */
	public function get_items_permissions($flag, $request) {

		$tax_obj = get_taxonomy($this->taxonomy);
		if (!$tax_obj || !$this->get_taxonomy_allowed(false)) {
			return false;
		}
		if ('edit' === $request['context'] && !current_user_can($tax_obj->cap->edit_terms)) {
			return new WP_Error('rest_forbidden_context', __('Sorry, you are not allowed to edit terms in this taxonomy.'), array('status' => rest_authorization_required_code()));
		}

		return true;
	}

	/**
	 * @param $flag
	 * @param $request
	 *
	 * @return bool|WP_Error
	 */
	public function get_item_permissions($flag, $request) {

		if (isset($request['id']) && 0 === $request['id']) {
			return true;
		}

		// $term = $this->get_term($request['id']);
		// NOTE : @ayush or @dipesh, it was invoking above line before, method don't exists though? By Ketan, May-2019
		$term = get_term($request['id']);

		if (is_wp_error($term)) {
			return $term;
		}

		if ('edit' === $request['context'] && !current_user_can('edit_term', $term->term_id)) {
			return new WP_Error('rest_forbidden_context', __('Sorry, you are not allowed to edit this term.'), array('status' => rest_authorization_required_code()));
		}

		return true;
	}

	/**
	 * @param $flag
	 *
	 * @return bool
	 */
	public function get_taxonomy_allowed($flag) {

		$taxonomy_obj = get_taxonomy($this->taxonomy);
		if ($taxonomy_obj && !empty($taxonomy_obj->show_in_rest)) {
			return true;
		}

		return false;
	}

	/**
	 * @param $result
	 * @param $prepared_args
	 * @param $request
	 *
	 * @return array
	 */
	public function get_course_categories($result, $prepared_args, $request) {

		$terms = array();
		$flagfetch = true;
		$offset = $prepared_args['offset'];
		$taxonomy_obj = get_taxonomy($this->taxonomy);

		if ($taxonomy_obj->hierarchical && isset($registered['parent'], $request['parent'])) {
			if (0 === $request['parent']) {
				// Only query top-level terms.
				$prepared_args['parent'] = 0;
			} else {
				if ($request['parent']) {
					$prepared_args['parent'] = $request['parent'];
				}
			}
		}

		if (isset($offset) & empty($offset)) {
			$prepared_args['number'] -= 1;
			if (empty($prepared_args['number'])) {
				$flagfetch = false;
			}
		} else {
			$prepared_args['offset'] -= 1;
		}

		if ($flagfetch) {
			if (!empty($prepared_args['post'])) {
				$terms = wp_get_object_terms($prepared_args['post'], $this->taxonomy, $prepared_args);

				// Used when calling wp_count_terms() below.
				$prepared_args['object_ids'] = $prepared_args['post'];
			} else {
				$terms = get_terms($this->taxonomy, $prepared_args);
			}

			foreach ($terms as $term) {
                $term->name = wp_specialchars_decode( $term->name ); //Fixed encoded special char
				$term->meta = $this->meta->get_value($term->term_id, $request);
				$term->link = get_term_link($term);
				$term->id = $term->term_id;
				$term->icon = $this->get_icon_media($term->term_id);
			}
		}

		if (isset($offset) & empty($offset)) {
			if (empty($request["include"])) {
				$terms[] = $this->get_uncategorised_category();
			}
		}

		$count_args = $prepared_args;

		unset($count_args['number'], $count_args['offset']);

		$total_terms = wp_count_terms($this->taxonomy, $count_args);

		return array('terms' => $terms, 'total_terms' => $total_terms);
	}

	/**
	 * @param $result
	 * @param $id
	 * @param $request
	 *
	 * @return object|WP_Error
	 */
	public function get_course_category($result, $id, $request) {

		if (isset($id) && !empty($id)) {
			$term = get_term((int) $id, $this->taxonomy);
			$term->meta = $this->meta->get_value($term->term_id, $request);
		} else if (isset($id) && 0 === $id) {
			$term = $term = $this->get_uncategorised_category();
		}

		if (empty($term) || $term->taxonomy !== $this->taxonomy) {
			return new WP_Error('rest_term_invalid', __('Term does not exist.'), array('status' => 404));
		}

		return $term;
	}

	/**
	 * @param int $term_id
	 *
	 * @return array
	 */
	public function get_icon_media($term_id = 0) {
		$return = array(
			"large" => null,
			"small" => null,
		);

		if (!empty($term_id) && term_exists($term_id)) {
			$large = bbapp_lms_taxonomy_image_url($term_id, 'full', true);
			$small = bbapp_lms_taxonomy_image_url($term_id, 'thumbnail', true);

			if (isset($large)) {
				$return["large"] = $large;
			}
			if (isset($small)) {
				$return["small"] = $small;
			}
		}

		return $return;

	}

	/**
	 * @return object
	 */
	private function get_uncategorised_category() {
		return (object) array(
			'term_id' => 0,
			'id' => 0,
			'link' => '',
			'name' => 'Uncategorised',
			'slug' => 'uncategorised',
			'term_group' => 0,
			'term_taxonomy_id' => 0,
			'taxonomy' => $this->taxonomy,
			'description' => '',
			'parent' => 0,
			'count' => 0,
			'filter' => 'raw',
			'meta' => array(),
			'icon' => $this->get_icon_media(),
		);
	}
}