<?php
namespace BuddyBossApp\Api\Learner\LearnDash;
use stdClass;
use WP_Query;

// NOTE : Old classname was class.bbapp_learner_learndash_certificates_rest. By Ketan, Oct-2019
// Contain functionality for required additional rest api endpoints for learndash - v1 Standard
class CertificatesRest {

	/**
	 * CertificatesRest constructor.
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 *
	 */
	public function hooks() {
		add_filter('bbapp_learner_get_certificates_items_permissions', array($this, 'getItemsPermissions'), 10, 2);

		//add_filter('bbapp_learner_get_certificates', array($this, "getCertificates"), 10, 2);
	}

	/**
	 * @param $flag
	 * @param $request
	 *
	 * @return bool
	 */
	public function getItemsPermissions($flag, $request) {
		return true;
	}

	/**
	 * @param $query_args
	 * @param $request
	 *
	 * @return array
	 */
	public function getCertificates($query_args, $request) {
		$user_id = get_current_user_id();

		/**
		 * Course Certificate
		 **/
		$user_courses = ld_get_mycourses($user_id, array());
		$certificates = array();
		foreach ($user_courses as $course_id) {

			$certificateLink = learndash_get_course_certificate_link($course_id, $user_id);
			$filename = "Certificate.pdf";
			$course_title = get_the_title($course_id);
			$certificate_id = learndash_get_setting($course_id, 'certificate');
			if (!empty($certificate_id)) {
				$certificate = get_post($certificate_id);
				$filename = sanitize_file_name($course_title) . "-" . sanitize_file_name($certificate->post_title) . ".pdf";
			}

			$date = get_user_meta($user_id, 'course_completed_' . $course_id, true);

			if (!empty($certificateLink)) {
				$certificate = new stdClass();
				$certificate->ID = $course_id;
				$certificate->link = $certificateLink;
				$certificate->title = get_the_title($course_id);
				$certificate->filename = $filename;
				$certificate->date = date("Y-m-d h:i:s", $date);
				$certificate->time = $date;
				$certificate->type = 'course';
				$certificates[] = $certificate;
			}
		}

		/**
		 * Quiz Certificate
		 **/
		$quizzes = get_user_meta($user_id, '_sfwd-quizzes', true);
		if (!empty($quizzes)) {
			$quiz_ids = wp_list_pluck($quizzes, 'quiz');
			if (!empty($quiz_ids)) {
				$quiz_total_query_args = array(
					'post_type' => 'sfwd-quiz',
					'fields' => 'ids',
					'orderby' => 'title', //$atts['quiz_orderby'],
					'order' => 'ASC', //$atts['quiz_order'],
					'nopaging' => true,
					'post__in' => $quiz_ids,
				);
				$quiz_query = new WP_Query($quiz_total_query_args);
				$quizzes_tmp = array();
				foreach ($quiz_query->posts as $post_idx => $quiz_id) {
					foreach ($quizzes as $quiz_idx => $quiz_attempt) {
						if ($quiz_attempt['quiz'] == $quiz_id) {
							$quiz_key = $quiz_attempt['time'] . '-' . $quiz_attempt['quiz'];
							$quizzes_tmp[$quiz_key] = $quiz_attempt;
							unset($quizzes[$quiz_idx]);
						}
					}
				}
				$quizzes = $quizzes_tmp;
				krsort($quizzes);
				if (!empty($quizzes)) {
					foreach ($quizzes as $quizdata) {
						if (!in_array($quizdata['quiz'], wp_list_pluck($certificates, 'ID'))) {
							$quiz_settings = learndash_get_setting($quizdata['quiz']);
							$certificate_post_id = intval($quiz_settings['certificate']);
							$certificate_data = learndash_certificate_details($quizdata['quiz'], $user_id);
							if (!empty($certificate_data['certificateLink']) && $certificate_data['certificate_threshold'] <= $quizdata['percentage'] / 100) {
								$filename = sanitize_file_name(get_the_title($quizdata['quiz'])) . "-" . sanitize_file_name(get_the_title($certificate_post_id)) . ".pdf";
								$certificate = new stdClass();
								$certificate->ID = $quizdata['quiz'];
								$certificate->link = $certificate_data['certificateLink'];
								$certificate->title = get_the_title($quizdata['quiz']);
								$certificate->filename = $filename;
								$certificate->date = date("Y-m-d h:i:s", $quizdata['time']);
								$certificate->time = $quizdata['time'];
								$certificate->type = 'quiz';
								$certificates[] = $certificate;
							}
						}

					}
				}
			}
		}

		usort($certificates, function ($a, $b) {
			return strcmp($b->time, $a->time);
		});

		return array('posts' => $certificates);

	}

}
